/*
 * Decompiled with CFR 0.152.
 */
package uws.service.file.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import uws.service.file.io.CloseAction;

public class RotateFileAction
implements CloseAction {
    private final File sourceFile;
    private final File targetFile;

    public RotateFileAction(File sourceFile, File targetFile) throws NullPointerException, IllegalArgumentException {
        if (sourceFile == null) {
            throw new NullPointerException("Missing source file!");
        }
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("The source file \"" + sourceFile.getAbsolutePath() + "\" does not exist!");
        }
        if (sourceFile.isDirectory()) {
            throw new IllegalArgumentException("The source file \"" + sourceFile.getAbsolutePath() + "\" is a directory instead of a regular file!");
        }
        if (targetFile == null) {
            throw new NullPointerException("Missing target file!");
        }
        if (targetFile.exists() && targetFile.isDirectory()) {
            throw new IllegalArgumentException("The target file \"" + targetFile.getAbsolutePath() + "\" is a directory instead of a regular file!");
        }
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
    }

    @Override
    public void run() throws IOException {
        try {
            Files.deleteIfExists(this.targetFile.toPath());
        }
        catch (IOException ioe) {
            throw new IOException("Impossible to perform the file rotation! Cause: the former file can not be deleted.", ioe);
        }
        try {
            Files.move(this.sourceFile.toPath(), this.targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            throw new IOException("Impossible to perform the file rotation! Cause: [" + ioe.getClass() + "] " + ioe.getMessage(), ioe);
        }
    }
}

