/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Parser;

public class Interval {
    private double[] range;

    public static Interval parseInterval(Map<String, String[]> params, String intervalParam) {
        String value = Parser.getSingleValue(params, intervalParam);
        if (value == null) {
            return null;
        }
        return new Interval(value);
    }

    Interval(String value) {
        this.range = Parser.parseIntervalString(value, "Interval");
    }

    public Interval(double low, double up) {
        this.range = new double[2];
        this.range[0] = low;
        this.range[1] = up;
    }

    public double getMin() {
        return this.range[0];
    }

    public double getMax() {
        return this.range[1];
    }

    public String toString(String prefix) {
        return prefix + "=" + this.range[0] + (this.range.length > 1 ? " " + this.range[1] : "");
    }

    public String boundsString() {
        return String.valueOf(new Double(this.range[0]).intValue()) + ":" + String.valueOf(new Double(this.range[1]).intValue());
    }
}

