/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractEcJwkFactory;
import io.jsonwebtoken.impl.security.DefaultEcPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import io.jsonwebtoken.impl.security.DefaultJwkContext;
import io.jsonwebtoken.impl.security.ECCurve;
import io.jsonwebtoken.impl.security.EcPublicJwkFactory;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.EcPrivateJwk;
import io.jsonwebtoken.security.EcPublicJwk;
import io.jsonwebtoken.security.InvalidKeyException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;

class EcPrivateJwkFactory
extends AbstractEcJwkFactory<ECPrivateKey, EcPrivateJwk> {
    private static final String ECPUBKEY_ERR_MSG = "JwkContext publicKey must be an " + ECPublicKey.class.getName() + " instance.";
    private static final EcPublicJwkFactory PUB_FACTORY = EcPublicJwkFactory.INSTANCE;

    EcPrivateJwkFactory() {
        super(ECPrivateKey.class, DefaultEcPrivateJwk.PARAMS);
    }

    @Override
    protected boolean supportsKeyValues(JwkContext<?> ctx) {
        return super.supportsKeyValues(ctx) && ctx.containsKey(DefaultEcPrivateJwk.D.getId());
    }

    protected ECPublicKey derivePublic(KeyFactory keyFactory, ECPublicKeySpec spec) throws InvalidKeySpecException {
        return (ECPublicKey)keyFactory.generatePublic(spec);
    }

    protected ECPublicKey derivePublic(JwkContext<ECPrivateKey> ctx) {
        final ECPrivateKey key = ctx.getKey();
        return this.generateKey(ctx, ECPublicKey.class, new CheckedFunction<KeyFactory, ECPublicKey>(){

            @Override
            public ECPublicKey apply(KeyFactory kf) {
                try {
                    ECPublicKeySpec spec = ECCurve.publicKeySpec(key);
                    return EcPrivateJwkFactory.this.derivePublic(kf, spec);
                }
                catch (Exception e) {
                    String msg = "Unable to derive ECPublicKey from ECPrivateKey: " + e.getMessage();
                    throw new InvalidKeyException(msg, (Throwable)e);
                }
            }
        });
    }

    @Override
    protected EcPrivateJwk createJwkFromKey(JwkContext<ECPrivateKey> ctx) {
        ECPrivateKey key = ctx.getKey();
        PublicKey publicKey = ctx.getPublicKey();
        ECPublicKey ecPublicKey = publicKey != null ? (ECPublicKey)Assert.isInstanceOf(ECPublicKey.class, (Object)publicKey, (String)ECPUBKEY_ERR_MSG) : this.derivePublic(ctx);
        boolean copyId = !Strings.hasText((String)ctx.getId()) && ctx.getIdThumbprintAlgorithm() != null;
        JwkContext<ECPublicKey> pubCtx = PUB_FACTORY.newContext(ctx, ecPublicKey);
        EcPublicJwk pubJwk = (EcPublicJwk)PUB_FACTORY.createJwk(pubCtx);
        ctx.putAll((Map)pubJwk);
        if (copyId) {
            ctx.setId(pubJwk.getId());
        }
        int fieldSize = key.getParams().getCurve().getField().getFieldSize();
        String d = EcPrivateJwkFactory.toOctetString(fieldSize, key.getS());
        ctx.put(DefaultEcPrivateJwk.D.getId(), d);
        return new DefaultEcPrivateJwk(ctx, pubJwk);
    }

    @Override
    protected EcPrivateJwk createJwkFromValues(JwkContext<ECPrivateKey> ctx) {
        RequiredParameterReader reader = new RequiredParameterReader(ctx);
        String curveId = reader.get(DefaultEcPublicJwk.CRV);
        BigInteger d = reader.get(DefaultEcPrivateJwk.D);
        DefaultJwkContext pubCtx = new DefaultJwkContext(DefaultEcPublicJwk.PARAMS, ctx);
        EcPublicJwk pubJwk = (EcPublicJwk)EcPublicJwkFactory.INSTANCE.createJwk(pubCtx);
        ECCurve curve = EcPrivateJwkFactory.getCurveByJwaId(curveId);
        final ECPrivateKeySpec privateSpec = new ECPrivateKeySpec(d, curve.toParameterSpec());
        ECPrivateKey key = this.generateKey(ctx, new CheckedFunction<KeyFactory, ECPrivateKey>(){

            @Override
            public ECPrivateKey apply(KeyFactory kf) throws Exception {
                return (ECPrivateKey)kf.generatePrivate(privateSpec);
            }
        });
        ctx.setKey(key);
        return new DefaultEcPrivateJwk(ctx, pubJwk);
    }
}

