/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import uws.UWSException;
import uws.UWSExceptionFactory;
import uws.UWSToolBox;
import uws.job.ExecutionPhase;
import uws.job.JobDestructionPolicy;
import uws.job.SerializableUWSObject;
import uws.job.UWSJob;
import uws.job.manager.DefaultDestructionManager;
import uws.job.manager.DefaultExecutionManager;
import uws.job.manager.DestructionManager;
import uws.job.manager.ExecutionManager;
import uws.job.serializer.UWSSerializer;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSUrl;
import uws.service.log.UWSLog;

public class JobList
extends SerializableUWSObject
implements Iterable<UWSJob> {
    private static final long serialVersionUID = 1L;
    public static final JobDestructionPolicy DEFAULT_JOB_DESTRUCTION_POLICY = JobDestructionPolicy.ALWAYS_DELETE;
    private final String name;
    protected final Map<String, UWSJob> jobsList;
    protected final Map<JobOwner, Map<String, UWSJob>> ownerJobs;
    private DestructionManager destructionManager = null;
    private JobDestructionPolicy destructionPolicy = DEFAULT_JOB_DESTRUCTION_POLICY;
    private ExecutionManager executionManager = null;
    private UWS uws = null;

    public JobList(String jobListName) throws NullPointerException {
        this(jobListName, null, new DefaultDestructionManager());
    }

    public JobList(String jobListName, ExecutionManager executionManager) throws NullPointerException {
        this(jobListName, executionManager, new DefaultDestructionManager());
    }

    public JobList(String jobListName, DestructionManager destructionManager) throws NullPointerException {
        this(jobListName, new DefaultExecutionManager(), destructionManager);
    }

    public JobList(String jobListName, ExecutionManager executionManager, DestructionManager destructionManager) throws NullPointerException {
        if (jobListName == null) {
            throw new NullPointerException("Missing job list name ! => Impossible to build the job list.");
        }
        if ((jobListName = jobListName.trim()).length() == 0) {
            throw new NullPointerException("Missing job list name ! => Impossible to build the job list.");
        }
        this.name = jobListName;
        this.jobsList = new ConcurrentHashMap<String, UWSJob>();
        this.ownerJobs = new ConcurrentHashMap<JobOwner, Map<String, UWSJob>>();
        this.executionManager = executionManager;
        if (destructionManager == null) {
            throw new NullPointerException("Missing destruction manager ! => Impossible to build the job list.");
        }
        this.destructionManager = destructionManager;
    }

    public final UWS getUWS() {
        return this.uws;
    }

    public final void setUWS(UWS newUws) throws IllegalStateException {
        if (newUws == null) {
            return;
        }
        if (newUws.equals(this.uws)) {
            return;
        }
        if (this.uws != null && this.getNbJobs() != 0) {
            throw new IllegalStateException("This jobs list (here: " + this.getName() + ") is already associated with a UWS and contains some jobs (size=" + this.getNbJobs() + "). A job list can not be part of several UWS instances and can not be moved into another UWS if not empty !");
        }
        this.uws = newUws;
    }

    public UWSLog getLogger() {
        if (this.getUWS() != null && this.getUWS().getLogger() != null) {
            return this.getUWS().getLogger();
        }
        return UWSToolBox.getDefaultLogger();
    }

    public final DestructionManager getDestructionManager() {
        return this.destructionManager;
    }

    public final void setDestructionManager(DestructionManager newManager) {
        if (newManager == null) {
            return;
        }
        DestructionManager oldManager = this.destructionManager;
        this.destructionManager = newManager;
        for (UWSJob job : this) {
            oldManager.remove(job);
            this.destructionManager.update(job);
        }
    }

    public final ExecutionManager getExecutionManager() {
        if (this.executionManager == null) {
            this.executionManager = this.uws == null ? new DefaultExecutionManager() : new DefaultExecutionManager(this.uws.getLogger());
        }
        return this.executionManager;
    }

    public final synchronized void setExecutionManager(ExecutionManager manager) {
        if (manager == null) {
            return;
        }
        ExecutionManager oldManager = this.executionManager;
        this.executionManager = manager;
        if (oldManager != null) {
            for (UWSJob job : this) {
                if (job.getPhase() == ExecutionPhase.PENDING || job.isFinished()) continue;
                oldManager.remove(job);
                this.executionManager.execute(job);
            }
        }
    }

    public final JobDestructionPolicy getDestroyPolicy() {
        return this.destructionPolicy;
    }

    public final void setDestructionPolicy(JobDestructionPolicy destroyPolicy) {
        this.destructionPolicy = destroyPolicy == null ? DEFAULT_JOB_DESTRUCTION_POLICY : destroyPolicy;
    }

    public UWSUrl getUrl() {
        if (this.uws == null || this.uws.getUrlInterpreter() == null) {
            return null;
        }
        return this.uws.getUrlInterpreter().listJobs(this.getName());
    }

    public final String getName() {
        return this.name;
    }

    public final UWSJob getJob(String jobID) {
        return this.jobsList.get(jobID);
    }

    public UWSJob getJob(String jobID, JobOwner user) throws UWSException {
        JobOwner owner;
        if (user != null && !user.hasReadPermission(this)) {
            throw new UWSException(550, UWSExceptionFactory.readPermissionDenied(user, true, this.getName()));
        }
        UWSJob job = this.jobsList.get(jobID);
        if (user != null && job != null && job.getOwner() != null && !(owner = job.getOwner()).equals(user) && !user.hasReadPermission(job)) {
            throw new UWSException(550, UWSExceptionFactory.readPermissionDenied(user, false, job.getJobId()));
        }
        return job;
    }

    public final Iterator<UWSJob> getJobs() {
        return this.iterator();
    }

    public Iterator<UWSJob> getJobs(JobOwner user) {
        if (user == null) {
            return this.iterator();
        }
        if (this.ownerJobs.containsKey(user)) {
            return this.ownerJobs.get(user).values().iterator();
        }
        return new Iterator<UWSJob>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public UWSJob next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public final Iterator<UWSJob> iterator() {
        return this.jobsList.values().iterator();
    }

    public final int getNbJobs() {
        return this.jobsList.size();
    }

    public final int getNbJobs(JobOwner user) {
        if (user == null) {
            return this.getNbJobs();
        }
        if (this.ownerJobs.containsKey(user)) {
            return this.ownerJobs.get(user).size();
        }
        return 0;
    }

    public final Iterator<JobOwner> getUsers() {
        return this.ownerJobs.keySet().iterator();
    }

    public final int getNbUsers() {
        return this.ownerJobs.size();
    }

    public final List<UWSJob> searchJobs(String runID) {
        ArrayList<UWSJob> foundJobs = new ArrayList<UWSJob>();
        String string = runID = runID != null ? runID.trim() : runID;
        if (runID != null && !runID.isEmpty()) {
            for (UWSJob job : this) {
                if (!job.getRunId().equalsIgnoreCase(runID)) continue;
                foundJobs.add(job);
            }
        }
        return foundJobs;
    }

    public synchronized String addNewJob(UWSJob j) throws UWSException {
        if (this.uws == null) {
            throw new IllegalStateException("Jobs can not be added to this job list until this job list is linked to a UWS!");
        }
        if (j == null || this.jobsList.containsKey(j.getJobId())) {
            return null;
        }
        JobOwner owner = j.getOwner();
        if (owner != null && !owner.hasWritePermission(this)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(owner, true, this.getName()));
        }
        j.setJobList(this);
        this.jobsList.put(j.getJobId(), j);
        if (owner != null) {
            if (!this.ownerJobs.containsKey(owner)) {
                this.ownerJobs.put(owner, new ConcurrentHashMap());
            }
            this.ownerJobs.get(owner).put(j.getJobId(), j);
        }
        if (owner != null && this.uws.getBackupManager() != null && j.getRestorationDate() == null) {
            this.uws.getBackupManager().saveOwner(j.getOwner());
        }
        this.destructionManager.update(j);
        j.applyPhaseParam(null);
        if (j.getRestorationDate() == null) {
            this.getLogger().logJob(UWSLog.LogLevel.INFO, j, "CREATED", "Job \"" + j.getJobId() + "\" successfully created and added in the job list \"" + this.getName() + "\".", null);
        }
        return j.getJobId();
    }

    public boolean archiveJob(String jobId) {
        UWSJob job = this.getJob(jobId);
        if (job != null) {
            job.archive();
            if (job.getOwner() != null && this.uws.getBackupManager() != null) {
                this.uws.getBackupManager().saveOwner(job.getOwner());
            }
            return true;
        }
        return false;
    }

    public boolean archiveJob(String jobId, JobOwner user) throws UWSException {
        if (user != null) {
            if (!user.hasWritePermission(this)) {
                throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, this.getName()));
            }
            UWSJob job = this.getJob(jobId);
            if (job != null && job.getOwner() != null && !user.equals(job.getOwner()) && !user.hasWritePermission(job)) {
                throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, false, jobId));
            }
        }
        return this.archiveJob(jobId);
    }

    public final void updateDestruction(UWSJob job) {
        if (this.destructionManager != null && job != null && job.getJobList() != null && job.getJobList().equals(this)) {
            this.destructionManager.update(job);
        }
    }

    protected UWSJob removeJob(String jobId) {
        UWSJob removedJob;
        UWSJob uWSJob = removedJob = jobId == null ? null : this.jobsList.remove(jobId);
        if (removedJob != null) {
            JobOwner owner = removedJob.getOwner();
            if (owner != null && this.ownerJobs.containsKey(owner)) {
                this.ownerJobs.get(owner).remove(jobId);
                if (this.ownerJobs.get(owner).isEmpty()) {
                    this.ownerJobs.remove(owner);
                }
            }
            if (this.destructionManager != null) {
                this.destructionManager.remove(removedJob);
            }
            return removedJob;
        }
        return null;
    }

    public boolean destroyJob(String jobId) {
        boolean dateReached;
        UWSJob job = this.getJob(jobId);
        if (job == null) {
            return false;
        }
        boolean bl = dateReached = job.getDestructionTime() != null && job.getDestructionTime().compareTo(new Date()) <= 0;
        if (job.getPhase() == ExecutionPhase.ARCHIVED || this.destructionPolicy == JobDestructionPolicy.ALWAYS_DELETE || this.destructionPolicy == JobDestructionPolicy.ARCHIVE_ON_DATE && !dateReached) {
            UWSJob destroyedJob = this.removeJob(jobId);
            if (destroyedJob != null) {
                destroyedJob.clearResources();
                if (destroyedJob.getOwner() != null && this.uws.getBackupManager() != null) {
                    this.uws.getBackupManager().saveOwner(destroyedJob.getOwner());
                }
                this.getLogger().logJob(UWSLog.LogLevel.INFO, destroyedJob, "DESTROY", "The job \"" + destroyedJob.getJobId() + "\" has been removed from the job list \"" + this.name + "\".", null);
                return true;
            }
            return false;
        }
        return this.archiveJob(jobId);
    }

    public boolean destroyJob(String jobId, JobOwner user) throws UWSException {
        if (user != null) {
            if (!user.hasWritePermission(this)) {
                throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, this.getName()));
            }
            UWSJob job = this.getJob(jobId);
            if (job != null && job.getOwner() != null && !user.equals(job.getOwner()) && !user.hasWritePermission(job)) {
                throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, false, jobId));
            }
        }
        return this.destroyJob(jobId);
    }

    public synchronized void clear() {
        ArrayList<String> jobIDs = new ArrayList<String>(this.jobsList.keySet());
        for (String id : jobIDs) {
            this.destroyJob(id);
        }
    }

    public synchronized void clear(JobOwner owner) throws UWSException {
        if (owner == null) {
            this.clear();
        } else {
            if (!owner.hasWritePermission(this)) {
                throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(owner, true, this.getName()));
            }
            if (this.ownerJobs.containsKey(owner)) {
                ArrayList<String> jobIDs = new ArrayList<String>(this.ownerJobs.get(owner).keySet());
                for (String id : jobIDs) {
                    this.destroyJob(id);
                }
                this.ownerJobs.remove(owner);
            }
        }
    }

    public void serialize(ServletOutputStream output, UWSSerializer serializer, JobOwner owner, JobListRefiner listRefiner) throws UWSException, IOException, Exception {
        if (output == null) {
            throw new NullPointerException("Missing serialization output stream!");
        }
        if (owner != null && !owner.hasReadPermission(this)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(owner, true, this.getName()));
        }
        String serialization = serializer.getJobList(this, owner, listRefiner, true);
        if (serialization == null) {
            throw new UWSException(500, "Incorrect serialization value (=NULL) ! => impossible to serialize " + this.toString() + ".");
        }
        output.print(serialization);
        output.flush();
    }

    @Override
    public String serialize(UWSSerializer serializer, JobOwner user) throws UWSException, Exception {
        if (user != null && !user.hasReadPermission(this)) {
            throw new UWSException(550, UWSExceptionFactory.writePermissionDenied(user, true, this.getName()));
        }
        return serializer.getJobList(this, user, true);
    }

    public String toString() {
        return "JOB_LIST {name: \"" + this.getName() + "\"; nbJobs: " + this.jobsList.size() + "}";
    }
}

