/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.UWSJob;
import uws.job.parameters.UWSParameters;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;

public class SetJobParam
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public SetJobParam(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Set Job Parameter";
    }

    @Override
    public String getDescription() {
        return "Sets the value of a job attribute/parameter of the specified job. (URL: {baseUWS_URL}/{jobListName}/{job-id}/{job-attribute}, Method: HTTP-POST or HTTP-PUT, Parameter: {JOB-ATTRIBUTE}={attribute-value})";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJob() && (request.getMethod().equalsIgnoreCase("post") && (!urlInterpreter.hasAttribute() || urlInterpreter.getAttributes().length == 1) || request.getMethod().equalsIgnoreCase("put") && urlInterpreter.getAttributes().length >= 2 && urlInterpreter.getAttributes()[0].equalsIgnoreCase("parameters") && UWSToolBox.hasParameter(urlInterpreter.getAttributes()[1], request, false));
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        UWSParameters params;
        UWSJob job = this.getJob(urlInterpreter);
        try {
            params = this.uws.getFactory().createUWSParameters(request);
        }
        catch (UWSException ue) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, request, "SET_PARAM", "Can not parse the sent UWS parameters!", ue);
            throw ue;
        }
        boolean updated = job.addOrUpdateParameters(params, user);
        this.uws.redirect(urlInterpreter.jobSummary(urlInterpreter.getJobListName(), job.getJobId()).getRequestURL(), request, user, this.getName(), response);
        return updated;
    }
}

