/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Iterator;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import vo.parameter.Interval;
import vo.parameter.Parser;

public class Time
extends Interval {
    private static final String ARG_TIME = "TIME";
    private static final String ARG_TIMESYS = "TIMESYS";
    public System system;

    public static Time parseTime(Map<String, String[]> params, String defaultSystem) {
        String value = Parser.getSingleValue(params, ARG_TIME);
        if (value == null) {
            return null;
        }
        String system = Parser.getSingleValue(params, ARG_TIMESYS, defaultSystem);
        return new Time(value, system);
    }

    public static Time parseTimeFromJson(String jsonString, String defaultSystem) {
        JSONParser parser = new JSONParser();
        String strValue = null;
        String strSystem = null;
        try {
            double max;
            double min;
            JSONObject jObj = (JSONObject)parser.parse(jsonString);
            strSystem = (String)jObj.get((Object)"timesys");
            JSONArray jIval = (JSONArray)jObj.get((Object)"time");
            if (jIval == null) {
                return null;
            }
            Iterator it = jIval.iterator();
            if (jIval.size() == 1) {
                max = min = ((Double)it.next()).doubleValue();
            } else if (jIval.size() == 2) {
                min = (Double)it.next();
                max = (Double)it.next();
            } else {
                throw new IllegalArgumentException("Time interval must have 1 or 2 values, but found: " + jIval.size() + " values");
            }
            strValue = String.valueOf(min) + " " + String.valueOf(max);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Time(strValue, strSystem);
    }

    public Time(String strValue, String strSystem) {
        super(strValue);
        this.system = System.valueOf(strSystem);
    }

    public void setSystem(String strSystem) {
        this.system = System.valueOf(strSystem);
    }

    public String toString() {
        return super.toString(ARG_TIME) + "&TIMESYS=" + this.system.toString();
    }

    public String toJsonString() {
        JSONObject j = new JSONObject();
        j.put((Object)"timesys", (Object)this.system.toString());
        JSONArray arr = new JSONArray();
        arr.add((Object)this.getMin());
        arr.add((Object)this.getMax());
        j.put((Object)"time", (Object)arr);
        return j.toString();
    }

    public static enum System {
        MJD_UTC,
        GRID,
        NONE;

    }
}

