/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AuthConfig {
    private final String clientId;
    private final String clientSecret;
    private final String rapBaseUri;
    private final String accessTokenEndpoint;
    private final String checkTokenEndpoint;
    private final String userAuthorizationEndpoint;
    private final String jwksEndpoint;
    private final String rapWsUserEndpoint;
    private final String loginEndpoint;
    private final String scope;
    private final boolean groupsAutoload;
    private final int groupsCacheExpiration;
    private final String groupsPrefix;
    private final String gmsUri;
    private final boolean storeStateOnLoginEndpoint;
    private final boolean allowAnonymousAccess;
    private final boolean useClientCredentials;
    private final Class<?> rapClientClass;

    protected AuthConfig() {
        Properties properties = AuthConfig.loadConfigProperties();
        this.rapBaseUri = AuthConfig.getMandatoryProperty(properties, "rap_uri");
        this.clientId = properties.getProperty("client_id");
        this.clientSecret = properties.getProperty("client_secret");
        this.accessTokenEndpoint = properties.getProperty("access_token_endpoint");
        this.userAuthorizationEndpoint = properties.getProperty("user_authorization_endpoint");
        this.checkTokenEndpoint = properties.getProperty("check_token_endpoint");
        this.jwksEndpoint = properties.getProperty("jwks_endpoint");
        this.rapWsUserEndpoint = properties.getProperty("rap_ws_user_endpoint");
        this.loginEndpoint = (String)properties.getOrDefault((Object)"login_endpoint", "/login");
        this.scope = (String)properties.getOrDefault((Object)"scope", "openid");
        this.groupsAutoload = Boolean.parseBoolean((String)properties.getOrDefault((Object)"groups_autoload", String.valueOf(true)));
        this.groupsCacheExpiration = Integer.parseInt((String)properties.getOrDefault((Object)"groups_cache_expiration", String.valueOf(5)));
        this.groupsPrefix = (String)properties.getOrDefault((Object)"groups_prefix", "");
        this.gmsUri = properties.getProperty("gms_uri");
        this.storeStateOnLoginEndpoint = Boolean.parseBoolean((String)properties.getOrDefault((Object)"store_state_on_login_endpoint", String.valueOf(false)));
        this.allowAnonymousAccess = Boolean.parseBoolean((String)properties.getOrDefault((Object)"allow_anonymous_access", String.valueOf(true)));
        this.useClientCredentials = Boolean.parseBoolean((String)properties.getOrDefault((Object)"client_credentials", String.valueOf(false)));
        this.rapClientClass = AuthConfig.getRapClientClass(properties.getProperty("rap_client_class"));
    }

    private static Properties loadConfigProperties() {
        Properties properties = new Properties();
        try (InputStream in = AuthConfig.getConfigFileInputStream();){
            properties.load(in);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while loading config file", ex);
        }
        return properties;
    }

    private static InputStream getConfigFileInputStream() throws IOException {
        InputStream in = null;
        String configPath = System.getenv("AUTH_CONFIG_PATH");
        if (configPath != null) {
            File configFile = new File(configPath);
            if (!configFile.exists()) {
                throw new IllegalStateException("Config file not found: " + configPath);
            }
            in = new FileInputStream(configFile);
        } else {
            in = AuthConfig.class.getClassLoader().getResourceAsStream("auth.properties");
            if (in == null) {
                throw new IllegalStateException("auth.properties not found in class path");
            }
        }
        return in;
    }

    private static String getMandatoryProperty(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value == null) {
            AuthConfig.throwMissingPropertyException(key);
        }
        return value;
    }

    public static void checkLoginConfiguration(AuthConfig config) {
        if (!AuthConfig.isConfigured(config.clientId)) {
            AuthConfig.throwMissingPropertyException("client_id");
        }
        if (!AuthConfig.isConfigured(config.clientSecret)) {
            AuthConfig.throwMissingPropertyException("client_secret");
        }
    }

    private static boolean isConfigured(String property) {
        return property != null && !property.isBlank();
    }

    private static void throwMissingPropertyException(String key) {
        throw new IllegalStateException("Property " + key + " not found in config file");
    }

    private static Class<?> getRapClientClass(String className) {
        if (className == null || className.isBlank()) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Invalid RAP client class: " + className);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRapBaseUri() {
        return this.rapBaseUri;
    }

    public String getUserAuthorizationEndpoint() {
        return this.userAuthorizationEndpoint;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public String getCheckTokenEndpoint() {
        return this.checkTokenEndpoint;
    }

    public String getJwksEndpoint() {
        return this.jwksEndpoint;
    }

    public String getRapWsUserEndpoint() {
        return this.rapWsUserEndpoint;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean groupsAutoload() {
        return this.groupsAutoload;
    }

    public int getGroupsCacheExpiration() {
        return this.groupsCacheExpiration;
    }

    public String getGroupsPrefix() {
        return this.groupsPrefix;
    }

    public String getGmsUri() {
        return this.gmsUri;
    }

    public boolean storeStateOnLoginEndpoint() {
        return this.storeStateOnLoginEndpoint;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public boolean isClientCredentials() {
        return this.useClientCredentials;
    }

    public Class<?> getRapClientClass() {
        return this.rapClientClass;
    }
}

