/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import it.inaf.ia2.aa.jwt.InvalidTokenException;
import it.inaf.ia2.aa.jwt.Jwk;
import it.inaf.ia2.aa.jwt.JwksClient;
import java.security.Key;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenParser {
    private static final Logger LOG = LoggerFactory.getLogger(TokenParser.class);
    private final JwksClient jwksClient;
    private final Cache<String, Jwk> jwkCache;
    private final SigningKeyResolver signingKeyResolver;

    public TokenParser(JwksClient jwksClient) {
        this.jwksClient = jwksClient;
        this.jwkCache = new Cache2kBuilder<String, Jwk>(){}.expireAfterWrite(1L, TimeUnit.DAYS).build();
        this.signingKeyResolver = new SigningKeyResolverAdapter(){

            public Key resolveSigningKey(JwsHeader header, Claims claims) {
                String kid = (String)header.get((Object)"kid");
                if (kid == null) {
                    throw new InvalidTokenException("Missing kid in token");
                }
                return TokenParser.this.getJwk(kid).getKey();
            }
        };
    }

    private Jwk getJwk(String kid) {
        return (Jwk)this.jwkCache.computeIfAbsent((Object)kid, () -> this.jwksClient.readJwks().stream().filter(k -> kid.equals(k.getKid())).findFirst().orElseThrow(() -> new InvalidTokenException("No key found for kid " + kid)));
    }

    public Map<String, Object> getClaims(String token) {
        Jwt jwt;
        try {
            jwt = Jwts.parser().setSigningKeyResolver(this.signingKeyResolver).parse(token);
        }
        catch (ExpiredJwtException ex) {
            throw new InvalidTokenException("JWT is expired", ex);
        }
        catch (MalformedJwtException ex) {
            throw new InvalidTokenException("Malformed JWT", ex);
        }
        catch (SignatureException ex) {
            throw new InvalidTokenException("Invalid signature", ex);
        }
        catch (JwtException ex) {
            LOG.error("Exception while parsing token", (Throwable)ex);
            throw new InvalidTokenException("Invalid token", ex);
        }
        return (Map)jwt.getBody();
    }

    public SigningKeyResolver getSigningKeyResolver() {
        return this.signingKeyResolver;
    }
}

