/*
 * Decompiled with CFR 0.152.
 */
package uws.job;

import java.io.Serializable;
import uws.UWSException;
import uws.UWSExceptionFactory;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;

public class JobPhase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ExecutionPhase phase = ExecutionPhase.PENDING;
    protected final UWSJob job;

    public JobPhase(UWSJob j) throws NullPointerException {
        if (j == null) {
            throw new NullPointerException("Missing job instance ! => impossible to build a JobPhase instance.");
        }
        this.job = j;
    }

    public final UWSJob getJob() {
        return this.job;
    }

    public final ExecutionPhase getPhase() {
        return this.phase;
    }

    public final void setPhase(ExecutionPhase p) throws UWSException {
        this.setPhase(p, false);
    }

    public void setPhase(ExecutionPhase p, boolean force) throws UWSException {
        if (p == null) {
            return;
        }
        switch (p) {
            case PENDING: {
                this.setPendingPhase(force);
                break;
            }
            case QUEUED: {
                this.setQueuedPhase(force);
                break;
            }
            case EXECUTING: {
                this.setExecutingPhase(force);
                break;
            }
            case COMPLETED: {
                this.setCompletedPhase(force);
                break;
            }
            case ABORTED: {
                this.setAbortedPhase(force);
                break;
            }
            case ERROR: {
                this.setErrorPhase(force);
                break;
            }
            case HELD: {
                this.setHeldPhase(force);
                break;
            }
            case SUSPENDED: {
                this.setSuspendedPhase(force);
                break;
            }
            case ARCHIVED: {
                this.setArchivedPhase(force);
                break;
            }
            default: {
                this.setUnknownPhase(force);
            }
        }
    }

    protected void setPendingPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.PENDING));
        }
        this.phase = ExecutionPhase.PENDING;
    }

    protected void setQueuedPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.QUEUED && this.phase != ExecutionPhase.HELD && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.QUEUED));
        }
        this.phase = ExecutionPhase.QUEUED;
    }

    protected void setExecutingPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.EXECUTING && this.phase != ExecutionPhase.HELD && this.phase != ExecutionPhase.SUSPENDED && this.phase != ExecutionPhase.QUEUED && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.EXECUTING));
        }
        this.phase = ExecutionPhase.EXECUTING;
    }

    protected void setCompletedPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.COMPLETED && this.phase != ExecutionPhase.EXECUTING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.COMPLETED));
        }
        this.phase = ExecutionPhase.COMPLETED;
    }

    protected void setAbortedPhase(boolean force) throws UWSException {
        if (!(force || this.phase != ExecutionPhase.COMPLETED && this.phase != ExecutionPhase.ERROR && this.phase != ExecutionPhase.ARCHIVED)) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.ABORTED));
        }
        this.phase = ExecutionPhase.ABORTED;
    }

    protected void setErrorPhase(boolean force) throws UWSException {
        if (!(force || this.phase != ExecutionPhase.COMPLETED && this.phase != ExecutionPhase.ABORTED && this.phase != ExecutionPhase.ARCHIVED)) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.ERROR));
        }
        this.phase = ExecutionPhase.ERROR;
    }

    protected void setHeldPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.HELD && this.phase != ExecutionPhase.PENDING && this.phase != ExecutionPhase.EXECUTING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.HELD));
        }
        this.phase = ExecutionPhase.HELD;
    }

    protected void setSuspendedPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.SUSPENDED && this.phase != ExecutionPhase.EXECUTING && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.SUSPENDED));
        }
        this.phase = ExecutionPhase.SUSPENDED;
    }

    protected void setArchivedPhase(boolean force) throws UWSException {
        if (!force && this.phase != ExecutionPhase.ARCHIVED && this.phase != ExecutionPhase.COMPLETED && this.phase != ExecutionPhase.ABORTED && this.phase != ExecutionPhase.ERROR && this.phase != ExecutionPhase.UNKNOWN) {
            throw new UWSException(400, UWSExceptionFactory.incorrectPhaseTransition(this.job.getJobId(), this.phase, ExecutionPhase.ARCHIVED));
        }
        this.phase = ExecutionPhase.ARCHIVED;
    }

    protected void setUnknownPhase(boolean force) throws UWSException {
        this.phase = ExecutionPhase.UNKNOWN;
    }

    public boolean isJobUpdatable() {
        return this.phase == ExecutionPhase.PENDING;
    }

    public boolean isFinished() {
        return this.phase == ExecutionPhase.COMPLETED || this.phase == ExecutionPhase.ABORTED || this.phase == ExecutionPhase.ERROR || this.phase == ExecutionPhase.ARCHIVED;
    }

    public boolean isExecuting() {
        return this.phase == ExecutionPhase.EXECUTING || this.phase == ExecutionPhase.SUSPENDED;
    }

    public String toString() {
        return ExecutionPhase.getStr(this.phase);
    }
}

