#ifndef DBCONN_HPP
#define DBCONN_HPP

#include <string>
#include <pqxx/pqxx>

#include "SqlSurvey.hpp"



typedef struct cut_db_params
{
   std::string header;
   std::string filename;
   unsigned int hdunum;
   double rest_frequency;
   std::string velocity_fits_unit;
   std::string storage_path;
   std::string name;
   std::string species;
   std::string transition;
} cut_db_params_t;




class DbConn
{
   public:

/*      DbConn
         (std::string dbms,
          std::string host_name,
          std::string port,
          std::string schema,
          std::string db_name,
          std::string user_name,
          std::string password
         );
*/
      DbConn(std::string db_uri, std::string schema);


      cut_db_params_t queryCutParams(std::string pubdid);
      cut_db_params_t BqueryCutParams(std::string pubdid);
      std::string queryPubdid(int hid);
      int queryMaxHid(void);

      // utils
      void dbExecCmds(const std::vector<std::string> sqlCmds);
      void dbExecQuery(std::string query);
      pqxx::result dbExecQuery3(std::string query);
      std::vector<std::string> dbExecQuery2(std::string query);
      std::vector<std::string> queryTableNames(void);
      Survey querySurveyAttributes(int sid);


   private:

      std::string m_schema;
      std::string m_uri;

      pqxx::connection m_conn;
};

#endif

