
#ifndef CONFIG_HPP
#define CONFIG_HPP

#include <string>
#include <map>


class config
{
   public:

      void read_config(const std::string & settings_path);

      std::string getLogDir() const      {return m_settings.at(log_dir);}
      std::string getLogFileName() const {return m_settings.at(log_filename);}

//     std::string getAuthority() const          {return m_settings.at(ivoid_authority);}
//      std::string getResourceKey() const        {return m_settings.at(ivoid_resource_key);}
//      std::string getObsCorePublisher() const   {return std::string{"ivo://"} + getAuthority() + std::string{"/"} + getResourceKey();}
//      std::string getObsCoreAccessFormat() const {return m_settings.at(obscore_access_format);}
      
//      std::string getRemoteFitsDir() const {return m_settings.at(fits_url);}
      std::string getFitsDir() const       {return m_settings.at(fits_dir);}
      std::string getFitsCutDir() const    {return m_settings.at(fits_cutdir);}
/*
      std::string getDbms() const       {return m_settings.at(db_dbms);}
      std::string getDbHostName() const {return m_settings.at(db_host_name);}
      std::string getDbPort() const     {return m_settings.at(db_port);}
      std::string getDbSchema() const   {return m_settings.at(db_schema);}
      std::string getDbName() const     {return m_settings.at(db_name);}
      std::string getDbUserName() const {return m_settings.at(db_user_name);}
      std::string getDbPassword() const {return m_settings.at(db_password);}

      std::string getDbUri(bool with_password = false) const
      {return
	      m_settings.at(db_dbms)
		      + "://"
		      + m_settings.at(db_user_name)
		      + (with_password ? ":"+m_settings.at(db_password)  : "")
		      + "@"
		      + m_settings.at(db_host_name)
		      + ":"
		      + m_settings.at(db_port)
		      + "/"
		      + m_settings.at(db_name);
      }

      std::string getDbPostgresConnectString(bool with_password = false) const
      {return
	      "dbname = "  + m_settings.at(db_name)
		      + " port = " + m_settings.at(db_port)
		      + " host = " + m_settings.at(db_host_name)
		      + " user = " + m_settings.at(db_user_name)
		      + (with_password ? " password = " + m_settings.at(db_password)  : "")
		      + " options=\'-c search_path=" + m_settings.at(db_schema) + "\'";
      }
*/
   private:
      std::string value(std::string key) {return m_settings.at(key);}

      const std::string fits_dir{"fits_path_surveys"};
      const std::string fits_cutdir{"fits_path_cutouts"};

      const std::string log_dir{"log_dir"};
      const std::string log_filename{"log_filename"};

//      const std::string fits_url{"fits_url_surveys"};
/*      const std::string ivoid_authority{"ivoid_authority"};
      const std::string ivoid_resource_key{"ivoid_resource_key"};
      const std::string obscore_access_format{"obscore_access_format"};

      const std::string db_dbms{"db_dbms"};
      const std::string db_host_name{"db_host_name"};
      const std::string db_port{"db_port"};
      const std::string db_user_name{"db_user_name"};
      const std::string db_password{"db_password"};
      const std::string db_name{"db_name"};
      const std::string db_schema{"db_schema"};
*/
      //-------------------------------------------------
      // defaults
      //-------------------------------------------------

      const std::string empty_string;

      std::map<const std::string, std::string> m_settings 
      {
         {fits_dir, "/srv/surveys"},
         {fits_cutdir, "/srv/cutouts"},

         {log_dir, "/tmp"},
         {log_filename, "vlkbd.log"},
/*
            {ivoid_authority, 	empty_string},
            {ivoid_resource_key, 	empty_string},
            {obscore_access_format, 	"application/fits"},

            {fits_url, 	empty_string},

            {db_dbms, 	empty_string},
            {db_host_name,	empty_string},
            {db_port, 	empty_string},
            {db_user_name, 	empty_string},
            {db_password, 	empty_string},
            {db_name, 	empty_string},
            {db_schema, 	empty_string}
*/      
      };
};


#endif

