/*
 * Decompiled with CFR 0.152.
 */
package uws.service.wait;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.servlet.http.HttpServletRequest;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.wait.LimitedBlockingPolicy;

public class UserLimitedBlockingPolicy
extends LimitedBlockingPolicy {
    public static final int DEFAULT_NB_MAX_BLOCKED = 3;
    protected final int maxBlockedThreadsByUser;
    protected final Map<String, BlockingQueue<Thread>> blockedThreads;
    protected final boolean unblockOld;

    public UserLimitedBlockingPolicy() {
        this(60L, 3);
    }

    public UserLimitedBlockingPolicy(long timeout) {
        this(timeout, 3);
    }

    public UserLimitedBlockingPolicy(long timeout, int maxNbBlocked) {
        this(timeout, maxNbBlocked, true);
    }

    public UserLimitedBlockingPolicy(long timeout, int maxNbBlocked, boolean unblockOld) {
        super(timeout);
        this.maxBlockedThreadsByUser = maxNbBlocked <= 0 ? 3 : maxNbBlocked;
        this.blockedThreads = Collections.synchronizedMap(new HashMap());
        this.unblockOld = unblockOld;
    }

    protected final String buildKey(UWSJob job, JobOwner user, HttpServletRequest request) {
        if (user == null || user.getID() == null) {
            if (request == null) {
                return job.getJobId() + ";???";
            }
            return job.getJobId() + ";" + request.getRemoteAddr();
        }
        return job.getJobId() + ";" + user.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long block(Thread thread, long userDuration, UWSJob job, JobOwner user, HttpServletRequest request) {
        if (job == null || thread == null) {
            return 0L;
        }
        String id = this.buildKey(job, user, request);
        BlockingQueue<Thread> queue = this.blockedThreads.get(id);
        if (queue == null) {
            queue = new ArrayBlockingQueue<Thread>(this.maxBlockedThreadsByUser);
        }
        if (!queue.offer(thread)) {
            if (this.unblockOld) {
                Thread old = (Thread)queue.poll();
                if (old != null) {
                    Thread thread2 = old;
                    synchronized (thread2) {
                        old.notifyAll();
                    }
                }
                queue.offer(thread);
            } else {
                return 0L;
            }
        }
        this.blockedThreads.put(id, queue);
        return super.block(thread, userDuration, job, user, request);
    }

    @Override
    public void unblocked(Thread unblockedThread, UWSJob job, JobOwner user, HttpServletRequest request) {
        if (job == null || unblockedThread == null) {
            return;
        }
        String id = this.buildKey(job, user, request);
        BlockingQueue<Thread> queue = this.blockedThreads.get(id);
        if (queue != null) {
            Iterator it = queue.iterator();
            while (it.hasNext()) {
                if (!((Thread)it.next()).equals(unblockedThread)) continue;
                it.remove();
                if (queue.isEmpty()) {
                    this.blockedThreads.remove(id);
                }
                return;
            }
        }
    }
}

