/*
 * Decompiled with CFR 0.152.
 */
package uws.job.parameters;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uws.UWSException;
import uws.job.parameters.NumericParamController;

public class DurationParamController
extends NumericParamController {
    private static final long serialVersionUID = 1L;
    protected static final long MULT_SEC = 1000L;
    protected static final long MULT_MIN = 60000L;
    protected static final long MULT_HOURS = 3600000L;
    protected static final long MULT_DAYS = 86400000L;
    protected static final long MULT_WEEKS = 604800000L;
    protected static final long MULT_MONTHS = 2592000000L;
    protected static final long MULT_YEARS = 31536000000L;
    protected static String REGEXP_MS = "milliseconds|ms";
    protected static String REGEXP_SEC = "seconds|sec|s";
    protected static String REGEXP_MIN = "min|minutes|m";
    protected static String REGEXP_HOURS = "hours|h";
    protected static String REGEXP_DAYS = "days|D";
    protected static String REGEXP_WEEKS = "weeks|W";
    protected static String REGEXP_MONTHS = "months|M";
    protected static String REGEXP_YEARS = "years|Y";
    protected static Pattern PATTERN_DURATION = Pattern.compile("\\s*([0-9]+)\\s*(" + REGEXP_MS + "|" + REGEXP_SEC + "|" + REGEXP_MIN + "|" + REGEXP_HOURS + "|" + REGEXP_DAYS + "|" + REGEXP_WEEKS + "|" + REGEXP_MONTHS + "|" + REGEXP_YEARS + ")?\\s*");

    public DurationParamController() {
    }

    public DurationParamController(Long defaultValue, Long minValue, Long maxValue, boolean allowModification) {
        super(defaultValue, minValue, maxValue, allowModification);
    }

    @Override
    public void setDefault(Number newDefaultValue) {
        super.setDefault(newDefaultValue == null ? null : Long.valueOf(newDefaultValue.longValue()));
    }

    @Override
    public void setMinimum(Number newMinValue) {
        super.setMinimum(newMinValue == null ? null : Long.valueOf(newMinValue.longValue()));
    }

    @Override
    public void setMaximum(Number newMaxValue) {
        super.setMaximum(newMaxValue == null ? null : Long.valueOf(newMaxValue.longValue()));
    }

    @Override
    public Object check(Object value) throws UWSException {
        long numVal;
        if (value == null) {
            return this.getDefault();
        }
        if (value instanceof Number) {
            numVal = ((Number)value).longValue();
        } else if (value instanceof String) {
            try {
                numVal = this.parseDuration((String)value);
            }
            catch (ParseException pe) {
                throw new UWSException(400, "Wrong format for a duration parameter: \"" + value + "\"! It should be a positive long value between " + (this.minValue == null ? Integer.valueOf(0) : this.toString((Long)this.minValue)) + " and " + (this.maxValue == null ? this.toString(Long.MAX_VALUE) : this.toString((Long)this.maxValue)) + " (Default value: " + (this.defaultValue == null ? "none" : this.toString((Long)this.defaultValue)) + "). This value may be followed by a unit among: milliseconds (ms ; the default), seconds (s), minutes (min,m), hours (h), days (D), weeks (W), months (M) or years (Y).");
            }
        } else {
            throw new UWSException(500, "Wrong type for a duration parameter: class \"" + value.getClass().getName() + "\"! It should be a positive long value or a string containing only a positive long value eventually followed by a unit.");
        }
        if (this.minValue != null && (double)numVal < this.minValue.doubleValue()) {
            return this.minValue;
        }
        if (this.maxValue != null && (double)numVal > this.maxValue.doubleValue()) {
            return this.maxValue;
        }
        return numVal;
    }

    public long parseDuration(String duration) throws ParseException {
        if (duration == null || duration.matches("\\s*-.*")) {
            return -1L;
        }
        Matcher matcher = PATTERN_DURATION.matcher(duration);
        if (!matcher.matches()) {
            throw new ParseException("Unexpected format for a duration: \"" + duration + "\"! Cause: it does not match the following Regular Expression: " + PATTERN_DURATION.pattern(), 0);
        }
        try {
            long numDuration = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2);
            if (unit == null || unit.length() == 0 || unit.matches("(" + REGEXP_MS + ")")) {
                return numDuration;
            }
            if (unit.matches("(" + REGEXP_SEC + ")")) {
                return numDuration * 1000L;
            }
            if (unit.matches("(" + REGEXP_MIN + ")")) {
                return numDuration * 60000L;
            }
            if (unit.matches("(" + REGEXP_HOURS + ")")) {
                return numDuration * 3600000L;
            }
            if (unit.matches("(" + REGEXP_DAYS + ")")) {
                return numDuration * 86400000L;
            }
            if (unit.matches("(" + REGEXP_WEEKS + ")")) {
                return numDuration * 604800000L;
            }
            if (unit.matches("(" + REGEXP_MONTHS + ")")) {
                return numDuration * 2592000000L;
            }
            if (unit.matches("(" + REGEXP_YEARS + ")")) {
                return numDuration * 31536000000L;
            }
        }
        catch (Exception ex) {
            throw new ParseException("Unexpected format for a duration: \"" + duration + "\"! Cause: " + ex.getMessage(), matcher.regionStart());
        }
        return -1L;
    }

    public String toString(Long duration) {
        if (duration == null) {
            return "";
        }
        if (duration == 0L) {
            return "0ms";
        }
        if (duration % 31536000000L == 0L) {
            return duration / 31536000000L + "Y";
        }
        if (duration % 2592000000L == 0L) {
            return duration / 2592000000L + "M";
        }
        if (duration % 604800000L == 0L) {
            return duration / 604800000L + "W";
        }
        if (duration % 86400000L == 0L) {
            return duration / 86400000L + "D";
        }
        if (duration % 3600000L == 0L) {
            return duration / 3600000L + "h";
        }
        if (duration % 60000L == 0L) {
            return duration / 60000L + "m";
        }
        if (duration % 1000L == 0L) {
            return duration / 1000L + "s";
        }
        return duration + "ms";
    }
}

