## vlkb-soda

is a web-application to access astronomical data stored in FITS-files.
It implements SODA IVOA recommendation v1.0 (https://ivoa.net/documents/SODA/20170517/index.html).

*It can be used with vlkb-siav2 (https://ict.inaf.it/gitlab/ViaLactea/vlkb-siav2) to provide complete data discovery and access service.*


The SODA docker image is available in this repository and may be launched by an **compose.yaml** as in this example:

```yaml
version: '3' 

services:

  soda:
    container_name: soda-vlkb
    image: git.ia2.inaf.it:5050/vialactea/vlkb-soda/soda:1.7
    ports:
      - 18019:8080
    environment:
      - ACCESS_CONTEXT_ROOT=ska#datasets
    volumes:
      - /srv/ska/surveys:/srv/surveys:ro
    restart: always

```

The port number, ACCESS_CONTEXT_ROOT and directory to FITS-files must be adjusted for the given instance.

The above configuration example assumes:

* 'SKA' project holds FITS-files in sub-directories under: `/srv/ska/surveys`
* will be accessed remotely by URL: `http://<server>/ska/datasets/soda`
* identified by SODA-param ID which is an **IVOID** of the form:

`ID=ivo://<authority>/<resource-key>?<relative-pathname>#extnum`

The service decodes IVOID part after the question mark '?'.

The pathname in the ID is relative to the path in compose.yaml volume-mapping (e.g. `/srv/ska/surveys`).

The FITS extension number `#extnum` is optional. Default is the primary HDU.

Note that the service appends '**soda**' to ACCESS_CONTEXT_ROOT.
Then, a data access example:
```bash
curl -s -k --get
    --data-urlencode "ID=ivo://some-auth/some-key?some/path/somefile.fits"
    --data-urlencode "CIRCLE=202.256 47.493 0.2"
    -v -o soda.fits
    http://localhost:18019/ska/datasets/soda
```

cuts the file `/srv/ska/surveys/some/path/somefile.fits`.

The root URL `http://localhost:18019/ska/datasets/soda` returns the service descriptor.



## SODA for VLKB

Additionally to SODAv1 it also provides VLKB-specific functions:

- the filtering paramters (POS, BAND) can be given in GALACTIC and VELO-LSRK-km/s coordinates systems
- supports non-WCS cuts by pixels grid
- inserts additional metadata (RESTFREQ, CUNIT) if not present in FITS-headers
- can create and hold a cut-file server-side for later download, and
- provides count of undefined values in the cut-file

If the cuts are hold server-side also the following needs ot be configured:

* RESPONSE_FORMAT : application/x-vlkb-xml (default is application/fits)
* URL_CUTOUTS : server-side cuts can be downloaded form this URL


## Installation

The service consists of

- **vlkb-soda** web-application and associated **vlkbd** daemon to access FITS file contents based on VO SODA
- **vlkb** command line utility to perform some of the functionalities of the web-applications on command line


There are rpm, deb and war packages avaialable for Debian, CentOS and Fedora.

### Install from packages (rpm/deb and war)

There is a war-package for the cutout web-application

- vlkb-soda-X.Y.Z.war

And two packages for linux executables (deb or rpm)

- vlkbd-X.Y.Z.deb implements the cutout engine and should be installed together with vlkb-cutout-\*.war
- vlkb-X.Y.Z.deb is a optional utility

Additionally optional vlkb-obscore utility for the vlkb-search web-app:
- vlkb-obscore-X.Y.Z.deb is a optional tool to create ObsCore table for vlkb-search-\*.war

To download version X.Y, add one of the above package names to

```bash
FIXME   curl -O --header "PRIVATE-TOKEN: <security-token>"  "https://ict.inaf.it/gitlab/api/v4/projects/79/packages/generic/vlkb-datasets/X.Y/<package-name>"

```


