
#include "dataset_id.hpp"

#include "io.hpp"
#include "my_assert.hpp"

#include <string>

#include <limits.h> // PATH_MAX
#include <stdio.h>

using namespace std;






#define JOINCHAR_HDUNUM (2+2)
#define PUBDID_LEN (PATH_MAX + NAME_MAX + JOINCHAR_HDUNUM)
char * create_pubdid (const char * path, const char * filename,
            unsigned int hdunum, char * pubdid)
{
   // FIXME snprintf remove
   snprintf(pubdid,PUBDID_LEN,"%s_%s_%d",path, filename,hdunum);

   // remove_slash in pubdid string
   char *p = pubdid;
   while(*p !='\0')
   {   
      if(*p == '/') *p = '-';
      p++;
   }   

   return pubdid;
}




string dataset_id::create(const string path, const string filename, unsigned int hdunum, bool scramble)
{
   string pubdid_str;
   if(scramble)
   {
      char pubdid[PUBDID_LEN];
      create_pubdid (path.c_str(), filename.c_str(), hdunum, pubdid);
      pubdid_str = string{pubdid};
   }
   else
   {
      pubdid_str = path + "/" + filename;// FIXME + "[" + to_string(hdunum-1) + "]";
   }
   return pubdid_str;
}




