
import org.json.simple.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;




public class NeaLogEntry
{
   String serviceId = "vlkb";
   String action;
   String defaultLevel;


   NeaLogEntry(String argAction, String argDefLevel)
   {
      action         = argAction;
      defaultLevel   = argDefLevel;
   }



   String timeNowISO8601()
   {
      TimeZone tz = TimeZone.getTimeZone("UTC");
      SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
      df.setTimeZone(tz);
      String timeAsISO8601 = df.format(new Date());
      return timeAsISO8601;
   }





   JSONObject generateCommonInfo(String timestamp, String UserName, String resource)
   {
      JSONObject objCommon = new JSONObject();

      objCommon.put("timestamp", timestamp);
      objCommon.put("serviceid", serviceId);
      objCommon.put("level", defaultLevel);

      objCommon.put("resource", resource);
      objCommon.put("action", action);
      objCommon.put("userid", UserName);

      return objCommon;
   }



   String generateLoggingInfo(String timestamp, String UserName,
         String resource, String requestUrl, String clientIp)
   {
      JSONObject objLogging = generateCommonInfo(timestamp, UserName, resource);

      objLogging.put("url", requestUrl);
      objLogging.put("client_ip", clientIp);
 
      return objLogging.toString();
   }




   String generateAccountingInfo(String timestamp, String UserName, String resource,
         String measure, double value)
   {
      JSONObject objAccounting = generateCommonInfo(timestamp, UserName, resource);

      objAccounting.put("value", value);
      objAccounting.put("measure", measure);

      return objAccounting.toString();
   }

}

