
import java.security.Principal;
import java.util.List;

public class VlkbUser implements Principal {

    private String userId;
    private String userLabel;
    private String accessToken;
    private String idToken;
    private String refreshToken;
    private long expirationTime;
    private List<String> groups;

    @Override
    public String getName() {
        return userId;
    }   

    public VlkbUser setUserId(String userId) {
        this.userId = userId;
        return this;
    }   

    public String getUserLabel() {
        return userLabel;
    }   

    public VlkbUser setUserLabel(String userLabel) {
        this.userLabel = userLabel;
        return this;
    }   

    public String getAccessToken() {
        return accessToken;
    }   

    public VlkbUser setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }   

    public VlkbUser setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }   

    public String getRefreshToken() {
        return refreshToken;
    }   

    public String getIdToken() {
        return idToken;
    }   

    public VlkbUser setIdToken(String idToken) {
        this.idToken = idToken;
        return this;
    }

    public long getExpirationTime() {
        return expirationTime;
    }

    public VlkbUser setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public boolean isTokenExpired() {
        return getExpiresIn() < 0;
    }

    public long getExpiresIn() {
        return expirationTime - System.currentTimeMillis() / 1000;
    }

    public VlkbUser setExpiresIn(int expiresIn) {
        this.expirationTime = System.currentTimeMillis() / 1000 + expiresIn;
        return this;
    }

    public List<String> getGroups() {
        return groups;
    }

    public String[] getGroupsAsArray() {
        return groups.toArray(new String[0]);
    }


    public void setGroups(List<String> groups) {
        this.groups = groups;
    }
}

