
#include "cutout_ostream.hpp" // coordinates needed
#include "mcutout_ostream.hpp"
#include "cutout.hpp"
#include "mcutout.hpp"
#include "my_assert.hpp"

#include <iomanip> // setw
#include <iostream>
#include <vector>

using namespace std;


std::string to_string(content_type ss)
{
   string str;
   switch(ss)
   {
      case content_type::FILENAME: str = "FILENAME"; break;
      case content_type::BAD_REQUEST: str = "BAD_REQUEST"; break;
      case content_type::SERVICE_ERROR: str = "SERVICE_ERROR"; break;
   }
   my_assert(!str.empty(), __FILE__,__LINE__, "unrecognized value of content_type");
   return str;
}


std::ostream& operator<<( std::ostream &out, struct ::cut_param_s const& p)
{
   out << std::setw(20) << p.pubdid << " " << p.coord << " " << std::boolalpha << p.countNullVals
      << " " << p.filename << " " << p.hdunum << " extra_cards[" << p.cards.size() << "]";
   return out;
}

std::ostream& operator<<( std::ostream &out, struct cut_resp_s const& p)
{
   out << std::setw(20) << to_string(p.type) << " " << p.content << " for input: " << p.input;
   return out;
}


