
/* REC-SODA: UCD describing the CIRCLE parameter is pos.outline;obs.*/
/* REC-DALI Sect 3.3.6 Circle: definition */


class Circle
{

   double lon;
   double lat;
   double radius;

   public Circle(String value)
   {
      parseCircle(value);
   }

   private void parseCircle(String str)
   {
      String[] arr = str.strip().split(" +");

      if(arr == null)
         throw new IllegalArgumentException("CIRCLE : no value, or value contains no space");
      else
      {
         final int len = 3;
         if(arr.length != len)
            throw new IllegalArgumentException(
                  "CIRCLE : must have " + len + " elements delimited by space, but found " + arr.length);
         else
         {

            double dbl = Double.parseDouble(arr[0]);
            if ((dbl < 0) || (dbl > 360))
               throw new IllegalArgumentException("CIRCLE : first number must be in range [0,360] but found " + dbl);
            else
               this.lon = dbl;

            dbl = Double.parseDouble(arr[1]);
            if ((dbl < -90) || (dbl > 90))
               throw new IllegalArgumentException("CIRCLE : second number must be in range [-90,90] but found " + dbl);
            else
               this.lat = dbl;

            dbl = Double.parseDouble(arr[2]);
            if ((dbl <= 0) || (dbl > 180))
               throw new IllegalArgumentException("CIRCLE : third number must be in range (0,180] but found " + dbl);
            else
               this.radius = dbl;

         }
      }
   }

   public String toString()
   {
      return "CIRCLE " + Double.valueOf(lon) + " " + Double.valueOf(lat) + " " + Double.valueOf(radius);
   }

}

