
import java.util.Map;


class Parser
{

   public static String getFirstString(Map<String, String[]> params, String key)
   {
      String[] values = params.get(key);
      if (values == null) return null;

      if (values.length < 1)
         throw new IllegalArgumentException(key + " has no valid value");
      else
         return values[0];// FIXME if values[0] is null -> canot distinguish from key not found
   }


   public static String[] getFirstStringArray(Map<String, String[]> params, String key, String separator, int arrayLength)
   {
      String array = getFirstString(params, key);
      if (array == null) return null;

      String[] stringArray = array.split(separator);

      if(stringArray.length != arrayLength)
         throw new IllegalArgumentException(
               key + " parameter has incorrect number of elements (" 
               + stringArray.length + " vs " + arrayLength + ") or incorrect separator used");

      return stringArray;
   }


   public static double[] getDaliIntervalPositiveValues(String value, String errorMsgPrefix)
   {
      String[] arr = value.strip().split(" +");

      double[] dblArr = new double[2];

      if(arr == null)
         throw new IllegalArgumentException(errorMsgPrefix + " : no value, or value contains no space");
      else
      {
         final int len = 2;
         if(arr.length != len)
            throw new IllegalArgumentException(
                  errorMsgPrefix + " : must have " + len + " space-delimited elements, but found " + arr.length);
         else
         {


            String val = arr[0];
            if(val.equals("Inf") || val.equals("+Inf"))
            {
               dblArr[0] = Double.POSITIVE_INFINITY;
            }
            else
            {
               double dbl = Double.parseDouble(val);
               if (dbl < 0)
                  throw new IllegalArgumentException(errorMsgPrefix + " : values must be positive, but first value was " + dbl);
               else
                  dblArr[0] = dbl;
            }


            val = arr[1];
            if(val.equals("-Inf"))
            {
               // dblArr[1] = Double.NEGATIVE_INFINITY;
               throw new IllegalArgumentException(errorMsgPrefix + " : values must be positive, but second value was " + val);
            }
            else
            {
               double dbl = Double.parseDouble(val);
               if (dbl < 0)
                  throw new IllegalArgumentException(errorMsgPrefix + " : values must be positive, but second value was " + dbl);
               else
                  dblArr[1] = dbl;
            }
         }
      }

      return dblArr;
   }


}
