
/* REC ObsCore B.6.5.1. List of polarization states (pol_states)
... polarization labels inspired from the FITS specification. See Table 7 in FITS WCS Paper 1
(Greisen et Calabretta 2002) . Labels are combined using symbols from the

{I Q U V RR LL RL LR XX YY XY YX POLI POLA} set

and separated by a / character. A leading / character must start the list and
a trailing / character must end it. It should be ordered following the above list, compatible with
the FITS list table for polarization definition.
*/

// NOTE POLI POLA is not in FITS STOKES other match and are defined in FITS as: I=1...V=4 and  RR=-1...YX=-8

import java.util.Arrays;
import java.util.Set;
import java.util.HashSet;

class Pol
{
   final static Set<String> POL_STATES
      = new HashSet<>(Arrays.asList("I", "Q", "U", "V", "RR", "LL", "RL", "LR", "XX", "YY", "XY", "YX"));

   String[] states;

   Pol(String[] values)
   {
      for(String pol : values)
         if(!POL_STATES.contains(pol))
            throw new IllegalArgumentException("POL value is " + pol +" but must be one of " + String.join(" ", POL_STATES));

      this.states = values;
   }


   public String toString()
   {
      return "POL " + String.join(" ", states);
   }
}
