
import java.util.logging.Logger;


class Pos
{
   protected static final Logger LOGGER = Logger.getLogger("Pos");

   enum System {NONE, ICRS, GALACTIC};

   String shape;
   String value;

   System system;

   Circle  circle;
   Range   range;
   Polygon polygon;


   public Pos(Circle circle)   {this.shape = "CIRCLE";  this.circle  = circle;};
   public Pos(Range range)     {this.shape = "RANGE";   this.range  = range;};
   public Pos(Polygon polygon) {this.shape = "POLYGON"; this.polygon = polygon;};


   public Pos(String value)
   {
      LOGGER.info("trace: " + value);
      parsePos(value);
   }


   private void parsePos(String str)
   {
      String strArr[] = str.strip().split(" +", 2);

      if(strArr.length > 1)
      {
         this.shape = strArr[0].strip();
         this.value = strArr[1].strip();
      }
      else
      {
         throw new IllegalArgumentException("POS value must have more then one space-separated elements but had "
               + strArr.length + " elements)");
      }

      if(this.shape.equals("CIRCLE"))
      {
         this.circle = new Circle(this.value);
      }
      else if(this.shape.equals("RANGE"))
      {
         this.range = new Range(this.value);
      }
      else if(this.shape.equals("POLYGON"))
      {
         this.polygon = new Polygon(this.value);
      }
      else
      {
         throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape);
      }

   }

   public void setSystem(Pos.System system) { this.system = system; }

   public String toString()
   {
      String shapeStr;
      if(this.shape.equals("CIRCLE"))
      {
         shapeStr = this.circle.toString();
      }
      else if(this.shape.equals("RANGE"))
      {
         shapeStr = this.range.toString();
      }
      else if(this.shape.equals("POLYGON"))
      {
         shapeStr = this.polygon.toString();
      }
      else
      {
         throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape);
      }

     return "POS: " + shapeStr;
   }

}

