/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import vo.parameter.Parser;

public class Circle {
    private static final String ARG_CIRCLE = "CIRCLE";
    public double lon;
    public double lat;
    public double radius;

    public static Circle parseCircle(Map<String, String[]> params) {
        String value = Parser.getSingleValue(params, ARG_CIRCLE);
        if (value == null) {
            return null;
        }
        return new Circle(value);
    }

    public Circle(String value) {
        this.parseCircle(value);
    }

    private void parseCircle(String str) {
        String[] arr = str.strip().split(" +");
        if (arr == null) {
            throw new IllegalArgumentException("CIRCLE : no value, or value contains no space");
        }
        int len = 3;
        if (arr.length != 3) {
            throw new IllegalArgumentException("CIRCLE : must have 3 elements delimited by space, but found " + arr.length);
        }
        double dbl = Double.parseDouble(arr[0]);
        if (dbl < 0.0 || dbl > 360.0) {
            throw new IllegalArgumentException("CIRCLE : first number must be in range [0,360] but found " + dbl);
        }
        this.lon = dbl;
        dbl = Double.parseDouble(arr[1]);
        if (dbl < -90.0 || dbl > 90.0) {
            throw new IllegalArgumentException("CIRCLE : second number must be in range [-90,90] but found " + dbl);
        }
        this.lat = dbl;
        dbl = Double.parseDouble(arr[2]);
        if (dbl <= 0.0 || dbl > 180.0) {
            throw new IllegalArgumentException("CIRCLE : third number must be in range (0,180] but found " + dbl);
        }
        this.radius = dbl;
    }

    public String toString() {
        return "CIRCLE " + Double.valueOf(this.lon) + " " + Double.valueOf(this.lat) + " " + Double.valueOf(this.radius);
    }
}

