/*
 * Decompiled with CFR 0.152.
 */
package uws.service.request;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uws.UWSException;
import uws.job.jobInfo.XMLJobInfo;
import uws.service.file.UWSFileManager;
import uws.service.request.RequestParser;
import uws.service.request.UploadFile;

public class XMLRequestParser
implements RequestParser {
    public static final int DEFAULT_SIZE_LIMIT = 204800;
    public static int SIZE_LIMIT = 204800;
    public static final int DEFAULT_SMALL_XML_THRESHOLD = 2048;
    public static int SMALL_XML_THRESHOLD = 2048;
    protected final UWSFileManager fileManager;

    public XMLRequestParser(UWSFileManager fileManager) {
        if (fileManager == null) {
            throw new NullPointerException("Missing file manager => can not create an XMLRequestParser!");
        }
        this.fileManager = fileManager;
    }

    @Override
    public Map<String, Object> parse(HttpServletRequest request) throws UWSException {
        XMLJobInfo jobDesc = null;
        Object reqID = request.getAttribute("UWS_REQUEST_ID");
        if (reqID == null || !(reqID instanceof String)) {
            reqID = new Date().getTime();
        }
        File xmlFile = new File(this.fileManager.getTmpDirectory(), "JOB_DESCRIPTION_" + reqID);
        OutputStream output = null;
        BufferedInputStream input = null;
        long totalLength = 0L;
        try {
            input = new BufferedInputStream((InputStream)request.getInputStream());
            output = new BufferedOutputStream(new FileOutputStream(xmlFile));
            int maxSize = SIZE_LIMIT < 0 ? 204800 : SIZE_LIMIT;
            int memoryThreshold = SMALL_XML_THRESHOLD < 0 ? 2048 : SMALL_XML_THRESHOLD;
            String tooLargeErrorMsg = "XML document too large (>" + maxSize + " bytes) => Request rejected! You should see with the service administrator to extend this limit.";
            byte[] buffer = new byte[memoryThreshold + 1];
            int len = ((InputStream)input).read(buffer);
            if (len <= 0) {
                output.close();
                output = null;
                xmlFile.delete();
            } else if (len <= memoryThreshold) {
                output.close();
                output = null;
                xmlFile.delete();
                if (len > maxSize) {
                    throw new UWSException(413, tooLargeErrorMsg);
                }
                String smallXML = new String(buffer, 0, len, request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "UTF-8");
                this.validate(smallXML);
                jobDesc = new XMLJobInfo(smallXML);
            } else {
                do {
                    output.write(buffer, 0, len);
                    if ((totalLength += (long)len) <= (long)maxSize) continue;
                    output.close();
                    output = null;
                    xmlFile.delete();
                    throw new UWSException(413, tooLargeErrorMsg);
                } while ((len = ((InputStream)input).read(buffer)) > 0);
                output.flush();
                output.close();
                output = null;
                this.validate(xmlFile);
                UploadFile xmlUpload = new UploadFile("UWS_JOB_DESCRIPTION", xmlFile.toURI().toString(), this.fileManager);
                xmlUpload.mimeType = request.getContentType();
                xmlUpload.length = totalLength;
                jobDesc = new XMLJobInfo(xmlUpload);
            }
        }
        catch (IOException ioe) {
            xmlFile.delete();
            throw new UWSException(500, (Throwable)ioe, "Internal error => Impossible to get the XML document from the HTTP request!");
        }
        catch (UWSException ue) {
            xmlFile.delete();
            throw ue;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (jobDesc != null) {
            request.setAttribute("UWS_JOB_DESCRIPTION", jobDesc);
        }
        return new HashMap<String, Object>(0);
    }

    protected void validate(String smallXML) throws UWSException {
        this.validate(new ByteArrayInputStream(smallXML.getBytes()));
    }

    protected void validate(File xmlFile) throws UWSException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(xmlFile);
            this.validate(input);
        }
        catch (IOException ioe) {
            throw new UWSException(500, (Throwable)ioe);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void validate(InputStream input) throws UWSException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        SAXParser saxParser = null;
        try {
            saxParser = spf.newSAXParser();
            saxParser.parse(input, new DefaultHandler());
        }
        catch (SAXParseException spe) {
            throw new UWSException(400, "Incorrect XML input! ERROR at [l." + spe.getLineNumber() + ", c." + spe.getColumnNumber() + "]: " + spe.getMessage() + ".");
        }
        catch (Exception se) {
            throw new UWSException(500, (Throwable)se);
        }
    }

    public static final boolean isXMLRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().matches("(text|application)/(.+\\+)?xml");
    }
}

