/*
 * Decompiled with CFR 0.152.
 */
package uws.job.parameters;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import uws.ISO8601Format;
import uws.UWSException;
import uws.job.parameters.DestructionTimeController;
import uws.job.parameters.ExecutionDurationController;
import uws.job.parameters.InputParamController;
import uws.service.request.UploadFile;

public class UWSParameters
implements Iterable<Map.Entry<String, Object>> {
    protected static final String[] UWS_RW_PARAMETERS = new String[]{"phase", "runId", "executionDuration", "destruction", "parameters"};
    public static final String UWS_RW_PARAMETERS_REGEXP = "(phase|runId|executionDuration|destruction)".toLowerCase();
    protected static final String[] UWS_RO_PARAMETERS = new String[]{"jobId", "owner", "quote", "startTime", "endTime", "results", "error"};
    protected final Map<String, Object> params = new ConcurrentHashMap<String, Object>(10);
    private Map<String, Object> additionalParams = null;
    protected List<UploadFile> files = null;
    protected final Collection<String> expectedAdditionalParams;
    protected final Map<String, InputParamController> mapParamControllers = this.getDefaultControllers();

    public UWSParameters() {
        this(null, null);
    }

    public UWSParameters(Collection<String> expectedAdditionalParams, Map<String, InputParamController> inputParamControllers) {
        if (inputParamControllers != null) {
            this.mapParamControllers.putAll(inputParamControllers);
        }
        this.expectedAdditionalParams = expectedAdditionalParams;
    }

    public UWSParameters(HttpServletRequest request) throws UWSException {
        this(request, null, null);
    }

    public UWSParameters(HttpServletRequest request, Collection<String> expectedAdditionalParams, Map<String, InputParamController> inputParamControllers) throws UWSException {
        this(UWSParameters.getParameters(request), expectedAdditionalParams, inputParamControllers);
    }

    protected static Map<String, Object> getParameters(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        try {
            if (request.getAttribute("UWS_PARAMETERS") != null) {
                return (Map)request.getAttribute("UWS_PARAMETERS");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> map = new HashMap<String, Object>(request.getParameterMap().size());
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            int i;
            String n = (String)names.nextElement();
            String[] values = request.getParameterValues(n);
            for (i = values.length - 1; i >= 0 && values[i] == null; --i) {
            }
            if (i < 0) continue;
            map.put(n, values[i]);
        }
        return map;
    }

    public UWSParameters(Map<String, Object> params) throws UWSException {
        this(params, null, null);
    }

    public UWSParameters(Map<String, Object> params, Collection<String> expectedAdditionalParams, Map<String, InputParamController> inputParamControllers) throws UWSException {
        this(expectedAdditionalParams, inputParamControllers);
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Map<String, InputParamController> getDefaultControllers() {
        HashMap<String, InputParamController> controllers = new HashMap<String, InputParamController>(2);
        controllers.put("executionDuration", new ExecutionDurationController());
        controllers.put("destruction", new DestructionTimeController());
        return controllers;
    }

    protected InputParamController getController(String inputParamName) {
        return this.mapParamControllers.get(inputParamName);
    }

    protected Iterator<Map.Entry<String, InputParamController>> getControllers() {
        return this.mapParamControllers.entrySet().iterator();
    }

    @Override
    public final Iterator<Map.Entry<String, Object>> iterator() {
        return this.params.entrySet().iterator();
    }

    public final Set<String> getNames() {
        return this.params.keySet();
    }

    public final boolean isEmpty() {
        return this.params.isEmpty();
    }

    public final int size() {
        return this.params.size();
    }

    public final void init() {
        Iterator<Map.Entry<String, InputParamController>> itControllers = this.getControllers();
        if (itControllers != null) {
            while (itControllers.hasNext()) {
                Map.Entry<String, InputParamController> entry = itControllers.next();
                if (this.params.containsKey(entry.getKey()) || entry.getValue().getDefault() == null) continue;
                this.params.put(entry.getKey(), entry.getValue().getDefault());
            }
        }
    }

    public String[] update(UWSParameters newParams) throws UWSException {
        if (newParams != null && !newParams.params.isEmpty()) {
            this.additionalParams = null;
            this.files = null;
            String[] updated = new String[newParams.params.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : newParams) {
                InputParamController controller = this.getController(entry.getKey());
                if (controller != null && !controller.allowModification()) {
                    throw new UWSException(403, "The parameter \"" + entry.getKey() + "\" can not be modified after initialization!");
                }
                if (this.params.containsKey(entry.getKey()) || entry.getKey().toLowerCase().matches(UWS_RW_PARAMETERS_REGEXP)) {
                    if (entry.getValue() == null) {
                        throw new UWSException(403, "Removing a parameter (here: \"" + entry.getKey() + "\") from a job is forbidden!");
                    }
                    Object oldValue = this.params.get(entry.getKey());
                    if (oldValue != null && oldValue instanceof UploadFile) {
                        try {
                            ((UploadFile)oldValue).deleteFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                } else {
                    throw new UWSException(403, "Adding a parameter (here: \"" + entry.getKey() + "\") to an existing job is forbidden by the UWS protocol!");
                }
                this.params.put(entry.getKey(), entry.getValue());
                updated[i++] = entry.getKey();
            }
            return updated;
        }
        return new String[0];
    }

    public final Object get(String name) {
        String normalizedName = this.normalizeParamName(name);
        if (normalizedName == null) {
            return null;
        }
        if (normalizedName.equals("parameters")) {
            return this.getAdditionalParameters();
        }
        return this.params.get(normalizedName);
    }

    public final Iterator<UploadFile> getFiles() {
        if (this.files == null) {
            this.files = new ArrayList<UploadFile>(3);
            for (Object v : this.params.values()) {
                if (v == null) continue;
                if (v instanceof UploadFile) {
                    this.files.add((UploadFile)v);
                    continue;
                }
                if (!v.getClass().isArray()) continue;
                for (Object o : (Object[])v) {
                    if (!(o instanceof UploadFile)) continue;
                    this.files.add((UploadFile)o);
                }
            }
        }
        return this.files.iterator();
    }

    public final Object set(String name, Object value) throws UWSException {
        Object oldValue;
        if (value == null) {
            return this.remove(name);
        }
        String normalizedName = this.normalizeParamName(name);
        if (normalizedName == null) {
            return null;
        }
        this.additionalParams = null;
        this.files = null;
        if (normalizedName.equals("parameters")) {
            if (value instanceof Map) {
                try {
                    Map otherParams = (Map)value;
                    HashMap mapOldValues = new HashMap(otherParams.size());
                    Object oldValue2 = null;
                    for (Map.Entry entry : otherParams.entrySet()) {
                        oldValue2 = this.set((String)entry.getKey(), entry.getValue());
                        mapOldValues.put(entry.getKey(), oldValue2);
                    }
                    return mapOldValues;
                }
                catch (ClassCastException cce) {
                    return null;
                }
            }
            return null;
        }
        InputParamController controller = this.getController(normalizedName);
        if (controller != null) {
            value = controller.check(value);
        }
        if ((oldValue = this.params.get(normalizedName)) != null && oldValue instanceof UploadFile) {
            try {
                ((UploadFile)oldValue).deleteFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.params.put(normalizedName, value);
    }

    public Object remove(String inputParamName) {
        String normalizedName = this.normalizeParamName(inputParamName);
        if (normalizedName == null) {
            return null;
        }
        this.additionalParams = null;
        this.files = null;
        Object removed = this.params.remove(normalizedName);
        if (removed != null && removed instanceof UploadFile) {
            try {
                ((UploadFile)removed).deleteFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return removed;
    }

    protected String normalizeParamName(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        for (String uwsParam : UWS_RW_PARAMETERS) {
            if (!name.equalsIgnoreCase(uwsParam)) continue;
            return uwsParam;
        }
        for (String uwsParam : UWS_RO_PARAMETERS) {
            if (!name.equalsIgnoreCase(uwsParam)) continue;
            return null;
        }
        if (this.expectedAdditionalParams != null) {
            for (String param : this.expectedAdditionalParams) {
                if (!name.equalsIgnoreCase(param)) continue;
                return param;
            }
        }
        return name;
    }

    public final boolean hasInputPhase() {
        return this.params.get("phase") != null;
    }

    public final String getInputPhase() {
        if (this.hasInputPhase()) {
            return this.params.remove("phase").toString();
        }
        return null;
    }

    public final String getRunId() {
        return this.params.get("runId") != null ? this.params.get("runId").toString() : null;
    }

    public final long getExecutionDuration() {
        Object value = this.params.get("executionDuration");
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String) {
                try {
                    Long duration = Long.parseLong((String)value);
                    this.params.put("executionDuration", duration);
                    return duration;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0L;
    }

    public final Date getDestructionTime() {
        Object value = this.params.get("destruction");
        if (value != null) {
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof String) {
                try {
                    Date destruction = ISO8601Format.parseToDate((String)value);
                    this.params.put("destruction", destruction);
                    return destruction;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public final Map<String, Object> getAdditionalParameters() {
        if (this.additionalParams == null) {
            this.additionalParams = new ConcurrentHashMap<String, Object>(this.params.size());
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                int i;
                boolean uwsParam = false;
                for (i = 0; !uwsParam && i < UWS_RW_PARAMETERS.length; ++i) {
                    uwsParam = entry.getKey().equals(UWS_RW_PARAMETERS[i]);
                }
                for (i = 0; !uwsParam && i < UWS_RO_PARAMETERS.length; ++i) {
                    uwsParam = entry.getKey().equals(UWS_RO_PARAMETERS[i]);
                }
                if (uwsParam) continue;
                this.additionalParams.put(entry.getKey(), entry.getValue());
            }
        }
        return this.additionalParams;
    }
}

