
#ifndef COLMAP_HPP
#define COLMAP_HPP

#include <map>
#include <string>
#include <iostream>
#include <initializer_list>

template<typename Id, typename T>
class colmap : public std::map<Id, T>
{
   public:

      colmap<Id,T>(void):std::map<Id,T>(){};
      colmap<Id,T>(std::initializer_list<std::pair<Id const,T>> il):std::map<Id,T>(il){};


      std::string concat_val_all(const char separator = ',')
      {
         it = this->begin();

         if(it==this->end()) return "";
         // FIXME ho to handle this case ? -> exception?: there is nothing to concatinate

         std::string fullstr(it->second);

         it++;
         while(it != this->end())
         {
            fullstr.append(separator + it->second);
            it++;
         }

         return fullstr;
      }

      std::string concat_val_first_word(const char separator = ',')
      {
         it = this->begin();

         if(it==this->end()) return "";
         // FIXME ho to handle this case ? -> exception?: there is nothing to concatinate

         std::string fullstr(first_word(it->second));

         it++;
         while(it != this->end())
         {
            fullstr.append(separator + first_word(it->second));
            it++;
         }

         return fullstr;
      }


   private:
      typename std::map<Id, std::string>::iterator it;

      // utils
      std::string first_word(std::string str)
      {
         // if no match found, find return string::npos -> end-of-the-string
         return str.substr(0, str.find(' '));
      }

};

#endif
