
import java.util.logging.Logger;



class ResolverByObsCore implements Resolver
{
   private static final Logger LOGGER = Logger.getLogger(ResolverByObsCore.class.getName());

   private Settings.DBConn dbConn;
   private Subsurvey[] subsurveys;

   private String relPathname;
   private int hdunum;
   private String subsurveyId;
   private String accessUrl;


   public ResolverByObsCore(Settings.DBConn dbConn, Subsurvey[] subsurveys)
   {
      this.dbConn = dbConn;
      this.subsurveys = subsurveys;
   }


   public String relPathname() { return this.relPathname; }
   public int    hdunum() { return this.hdunum; }
   public String obsCollection() { return this.subsurveyId; }


   public void resolve(String pubdid)
   {
      LOGGER.info("trace " + pubdid);
      try
      {
         resolveByMapping(pubdid, dbConn);
      }
      catch(ClassNotFoundException e)
      {
         LOGGER.info("DB driver class was not loaded. No database connection.");
      }
      LOGGER.info("relPathname   : " + relPathname);
      LOGGER.info("hdunum        : " + String.valueOf(hdunum));
      LOGGER.info("obsCollection : " + this.subsurveyId);
   }



   private void resolveByMapping(String pubdid, Settings.DBConn dbConn) throws ClassNotFoundException
   {
      LOGGER.info("trace " + pubdid);

      if(this.subsurveys == null)
      {
         throw new IllegalStateException("subsurveys metadata is missing however storage-path is needed for resolve-by-mapping");
      }

      this.accessUrl   = null;
      this.subsurveyId = null; // VLKB stores subsurveyId in ObsCOre::obsCollection
      db_queryAccessUrlAndObsCollection(dbConn, pubdid);//, this.accessUrl, this.subsurveyId);

      if((accessUrl == null) || ((accessUrl != null) && (accessUrl.length() < 1)))
      {
         throw new IllegalStateException("ObsCore::accessUrl needed but is null or empty");
      }

      String fileName = accessUrl.substring( accessUrl.lastIndexOf('/') + 1, accessUrl.length() );

      /* NOTE accessURL & IVOID have after hash Extension-number:  hdunum = 1 + extnum */

      int ixTo = fileName.lastIndexOf("#");// returns -1 if hash not found
      boolean hash_not_found = (ixTo < 0);

      if(hash_not_found)
      {
         hdunum = 1;
      }
      else if( (ixTo + 1) == fileName.length() )
      {
         hdunum = 1; // filenames ending with hash seen as filename without extension number
      }
      else
      {
         hdunum = 1 + Integer.parseInt(fileName.substring(ixTo + 1));
         fileName = fileName.substring(0, ixTo);
      }

      Subsurvey subsurvey = Subsurvey.findSubsurvey(this.subsurveys, this.subsurveyId);
      String storagePath = subsurvey.storage_path;

      if((storagePath == null) || ((storagePath != null) && (storagePath.length() < 1)))
      {
         relPathname = fileName;
      }
      else
      {
         relPathname = storagePath + "/" + fileName;
      }
   }


   private void db_queryAccessUrlAndObsCollection(Settings.DBConn dbConn, String pubdid)//, String accessUrl, String obsCollection)
      throws ClassNotFoundException
   {
      LOGGER.info("trace");

      ResolverByObsCoreDb rdb;
      synchronized(ResolverByObsCoreDb.class)
      {
         ResolverByObsCoreDb.dbconn = dbConn;
         rdb = new ResolverByObsCoreDb();
      }

      String[] results = rdb.queryAccessUrlAndObsCollection(pubdid);
      if(results == null || ((results != null) && (results.length != 2)))
      {
         throw new IllegalStateException("query for accessUrl and obsCollection fails for: "+ pubdid +" in "+ dbConn.uri());
      }

      this.accessUrl   = results[0];
      this.subsurveyId = results[1];
   }

}
