/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.nio.ByteBuffer;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.type.PrimitiveType;

public class TileCompressor
extends TileCompressionOperation {
    private boolean forceNoLoss = false;

    protected TileCompressor(TiledImageCompressionOperation array, int tileIndex, TileArea area) {
        super(array, tileIndex, area);
    }

    @Override
    public void run() {
        this.compress();
    }

    private void compactCompressedData() {
        if (this.getTileIndex() > 0) {
            try {
                ((TileCompressionOperation)this.getPreviousTile()).waitForResult();
                ByteBuffer compressedWholeArea = this.getCompressedWholeArea();
                this.compressedOffset = compressedWholeArea.position();
                PrimitiveType.BYTE.appendBuffer(compressedWholeArea, this.compressedData);
                this.replaceCompressedBufferWithTargetArea(compressedWholeArea);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not compact compressed data", e);
            }
        } else {
            this.compressedOffset = 0;
            this.getCompressedWholeArea().position(this.compressedData.limit());
        }
    }

    private void compress() {
        boolean tryNormalCompression;
        this.initTileOptions();
        this.compressedData.limit(this.getTileBuffer().getPixelSize() * this.getBaseType().size());
        this.compressionType = TileCompressionType.COMPRESSED;
        boolean compressSuccess = false;
        boolean bl = tryNormalCompression = !this.tileOptions.isLossyCompression() || !this.forceNoLoss;
        if (tryNormalCompression) {
            compressSuccess = this.getCompressorControl().compress(this.getTileBuffer().getBuffer(), this.compressedData, this.tileOptions);
        }
        if (!compressSuccess) {
            this.compressionType = TileCompressionType.GZIP_COMPRESSED;
            this.compressedData.rewind();
            this.getTileBuffer().getBuffer().rewind();
            compressSuccess = this.getGzipCompressorControl().compress(this.getTileBuffer().getBuffer(), this.compressedData, null);
        }
        if (!compressSuccess) {
            this.compressionType = TileCompressionType.UNCOMPRESSED;
            this.compressedData.rewind();
            this.getTileBuffer().getBuffer().rewind();
            this.getBaseType().appendToByteBuffer(this.compressedData, this.getTileBuffer().getBuffer());
        }
        this.compressedData.limit(this.compressedData.position());
        this.compressedData.rewind();
        this.tileOptions.getCompressionParameters().setValueFromColumn(this.getTileIndex());
        this.compactCompressedData();
    }

    private void replaceCompressedBufferWithTargetArea(ByteBuffer compressedWholeArea) {
        int compressedSize = this.compressedData.limit();
        int latest = compressedWholeArea.position();
        compressedWholeArea.position(this.compressedOffset);
        this.compressedData = compressedWholeArea.slice();
        this.compressedData.limit(compressedSize);
        compressedWholeArea.position(latest);
    }

    @Override
    protected void forceNoLoss(boolean value) {
        this.forceNoLoss = value;
    }
}

