/*
 * Decompiled with CFR 0.152.
 */
package uws.job.jobInfo;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.job.serializer.XMLSerializer;

public class SingleValueJobInfo
implements JobInfo {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected String value = null;
    protected String xmlRepresentation = null;

    public SingleValueJobInfo(String name) throws NullPointerException, IllegalArgumentException {
        this(name, null);
    }

    public SingleValueJobInfo(String name, String value) throws NullPointerException, IllegalArgumentException {
        if (name == null || name.trim().length() == 0) {
            throw new NullPointerException("Missing SingleValueJobInfo name!");
        }
        if (!XMLSerializer.isValidXMLNodeName(name)) {
            throw new IllegalArgumentException("Invalid XML node name: \"" + name + "\"! You should choose a different name for your SingleValueJobInfo.");
        }
        this.name = name;
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.xmlRepresentation = "<" + this.name + ">" + XMLSerializer.escapeXMLData(this.value) + "</" + this.name + ">";
    }

    @Override
    public String getXML(String newLinePrefix) {
        return this.xmlRepresentation;
    }

    @Override
    public void write(HttpServletResponse response) throws IOException, UWSException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/xml");
        UWSToolBox.setContentLength(response, this.xmlRepresentation.getBytes("UTF-8").length);
        PrintWriter writer = response.getWriter();
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println(this.xmlRepresentation);
        writer.flush();
    }

    @Override
    public void setJob(UWSJob myJob) {
    }

    @Override
    public void destroy() throws UWSException {
    }
}

