/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.serializer.UWSSerializer;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;
import uws.service.request.UploadFile;

public class GetJobParam
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public GetJobParam(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Get Job Parameter";
    }

    @Override
    public String getDescription() {
        return "Gets the value of a job attribute/parameter of the specified job. (URL: {baseUWS_URL}/{jobListName}/{job-id}/{job-attribute}, Method: HTTP-GET, No parameter)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJobList() && urlInterpreter.hasAttribute() && request.getMethod().equalsIgnoreCase("get");
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        UWSJob job = this.getJob(urlInterpreter, user);
        String[] attributes = urlInterpreter.getAttributes();
        if (attributes[0].equalsIgnoreCase("results") && attributes.length > 1) {
            Result result = job.getResult(attributes[1]);
            if (result == null) {
                throw new UWSException(404, "No result identified with \"" + attributes[1] + "\" in the job \"" + job.getJobId() + "\"!");
            }
            if (result.isRedirectionRequired()) {
                this.uws.redirect(result.getHref(), request, user, this.getName(), response);
            } else {
                try (InputStream input = null;){
                    input = this.uws.getFileManager().getResultInput(result, job);
                    UWSToolBox.write(input, result.getMimeType(), result.getSize(), response);
                }
            }
        } else {
            if (attributes[0].equalsIgnoreCase("error") && attributes.length > 1 && attributes[1].equalsIgnoreCase("details")) {
                ErrorSummary error = job.getErrorSummary();
                if (error == null) {
                    throw new UWSException(404, "No error summary for the job \"" + job.getJobId() + "\"!");
                }
                try (InputStream input = null;){
                    input = this.uws.getFileManager().getErrorInput(error, job);
                    UWSToolBox.write(input, this.getUWS().getErrorWriter().getErrorDetailsMIMEType(), this.uws.getFileManager().getErrorSize(error, job), response);
                }
            }
            if (attributes[0].equalsIgnoreCase("jobInfo")) {
                if (job.getJobInfo() == null) {
                    response.sendError(204);
                } else {
                    job.getJobInfo().write(response);
                }
            } else if (attributes[0].equalsIgnoreCase("parameters") && attributes.length > 1 && job.getAdditionalParameterValue(attributes[1]) != null && job.getAdditionalParameterValue(attributes[1]) instanceof UploadFile) {
                UploadFile upl = (UploadFile)job.getAdditionalParameterValue(attributes[1]);
                if (upl.getLocation().matches("^http(s)?://")) {
                    this.uws.redirect(upl.getLocation(), request, user, this.getName(), response);
                } else {
                    try (InputStream input = null;){
                        input = this.uws.getFileManager().getUploadInput(upl);
                        UWSToolBox.write(input, upl.mimeType, upl.length, response);
                    }
                }
            } else {
                UWSSerializer serializer = this.uws.getSerializer(request.getHeader("Accept"));
                String uwsField = attributes[0];
                boolean jobSerialization = false;
                if (uwsField == null || uwsField.trim().isEmpty() || attributes.length <= 1 && (uwsField.equalsIgnoreCase("error") || uwsField.equalsIgnoreCase("results") || uwsField.equalsIgnoreCase("parameters"))) {
                    response.setContentType(serializer.getMimeType());
                    jobSerialization = true;
                } else {
                    response.setContentType("text/plain");
                }
                response.setCharacterEncoding("UTF-8");
                try {
                    job.serialize(response.getOutputStream(), attributes, serializer);
                }
                catch (Exception e) {
                    if (!(e instanceof UWSException)) {
                        String errorMsgPart = jobSerialization ? "the job \"" + job.getJobId() + "\"" : "the parameter " + uwsField + " of the job \"" + job.getJobId() + "\"";
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, urlInterpreter, "SERIALIZE", "Can not serialize " + errorMsgPart + "!", e);
                        throw new UWSException(500, (Throwable)e, "Can not format properly " + errorMsgPart + "!");
                    }
                    throw (UWSException)e;
                }
            }
        }
        return true;
    }

    public final boolean isDefaultUrl(Result result, UWSJob job) {
        if (result.getHref() == null || result.getHref().trim().isEmpty()) {
            return true;
        }
        return result.getHref().equals(Result.getDefaultUrl(result.getId(), job));
    }
}

