/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.aa;

import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.data.User;
import it.inaf.ia2.aa.jwt.InvalidTokenException;
import it.inaf.ia2.client.ClientException;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenFilter.class);
    private final ServiceLocator locator = ServiceLocator.getInstance();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            if (authHeader.startsWith("Bearer ")) {
                User user;
                String token = authHeader.substring("Bearer ".length());
                try {
                    user = this.locator.getUserManager().getUserFromAccessToken(token);
                }
                catch (InvalidTokenException ex) {
                    response.sendError(401, "Unauthorized: " + ex.getMessage());
                    return;
                }
                catch (ClientException ex) {
                    response.sendError(500, "Internal Server Error: " + ex.getMessage());
                    return;
                }
                RequestWithPrincipal requestWithPrincipal = new RequestWithPrincipal(request, user);
                chain.doFilter((ServletRequest)requestWithPrincipal, (ServletResponse)response);
                return;
            }
            LOGGER.warn("Detected Authorization header without bearer token. No Principal has been set.");
        }
        if (this.locator.getConfig().isAllowAnonymousAccess()) {
            chain.doFilter((ServletRequest)TokenFilter.getAnonymousServletRequest(request), (ServletResponse)response);
        } else {
            response.sendError(401, "Unauthorized");
        }
    }

    private static HttpServletRequestWrapper getAnonymousServletRequest(HttpServletRequest request) {
        User anonymousUser = new User().setUserId("anonymous").setUserLabel("Anonymous").setGroups(new ArrayList<String>());
        return new RequestWithPrincipal(request, anonymousUser);
    }

    private static class RequestWithPrincipal
    extends HttpServletRequestWrapper {
        private final User user;

        public RequestWithPrincipal(HttpServletRequest request, User user) {
            super(request);
            this.user = user;
        }

        public Principal getUserPrincipal() {
            return this.user;
        }
    }
}

