/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import vo.parameter.Parser;

public class Circle {
    private static final String ARG_CIRCLE = "CIRCLE";
    public double lon;
    public double lat;
    public double radius;

    public static Circle parseCircle(Map<String, String[]> params) {
        String value = Parser.getSingleValue(params, ARG_CIRCLE);
        if (value == null) {
            return null;
        }
        return new Circle(value);
    }

    public static Circle parseCircleFromJson(String jsonString) {
        JSONParser parser = new JSONParser();
        String valueString = null;
        try {
            JSONObject jObj = (JSONObject)parser.parse(jsonString);
            Double lon = (Double)jObj.get((Object)"lon");
            Double lat = (Double)jObj.get((Object)"lat");
            Double radius = (Double)jObj.get((Object)"radius");
            valueString = String.valueOf(lon) + " " + String.valueOf(lat) + " " + String.valueOf(radius);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Circle(valueString);
    }

    public Circle(double lon, double lat, double radius) {
        this.lon = lon;
        this.lat = lat;
        this.radius = radius;
    }

    public Circle(String value) {
        this.parseCircle(value);
    }

    private void parseCircle(String str) {
        String[] arr = str.strip().split(" +");
        if (arr == null) {
            throw new IllegalArgumentException("CIRCLE : no value, or value contains no space");
        }
        int len = 3;
        if (arr.length != 3) {
            throw new IllegalArgumentException("CIRCLE : must have 3 elements delimited by space, but found " + arr.length);
        }
        double dbl = Double.parseDouble(arr[0]);
        if (dbl < 0.0 || dbl > 360.0) {
            throw new IllegalArgumentException("CIRCLE : first number must be in range [0,360] but found " + dbl);
        }
        this.lon = dbl;
        dbl = Double.parseDouble(arr[1]);
        if (dbl < -90.0 || dbl > 90.0) {
            throw new IllegalArgumentException("CIRCLE : second number must be in range [-90,90] but found " + dbl);
        }
        this.lat = dbl;
        dbl = Double.parseDouble(arr[2]);
        if (dbl <= 0.0 || dbl > 180.0) {
            throw new IllegalArgumentException("CIRCLE : third number must be in range (0,180] but found " + dbl);
        }
        this.radius = dbl;
    }

    public String toString() {
        return "CIRCLE " + Double.valueOf(this.lon) + " " + Double.valueOf(this.lat) + " " + Double.valueOf(this.radius);
    }

    public String toJsonString() {
        return this.toJsonObject().toString();
    }

    public JSONObject toJsonObject() {
        JSONObject jObj = new JSONObject();
        jObj.put((Object)"lon", (Object)this.lon);
        jObj.put((Object)"lat", (Object)this.lat);
        jObj.put((Object)"radius", (Object)this.radius);
        return jObj;
    }

    public String lonBoundsString() {
        Double from = this.lon - this.radius;
        Double to = this.lon + this.radius;
        return String.valueOf(from.intValue()) + ":" + String.valueOf(to.intValue());
    }

    public String latBoundsString() {
        Double from = this.lat - this.radius;
        Double to = this.lat + this.radius;
        return String.valueOf(from.intValue()) + ":" + String.valueOf(to.intValue());
    }
}

