
import java.util.logging.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.io.PrintWriter;


class AuthZSettings
{
   private static final Logger LOGGER = Logger.getLogger(AuthZSettings.class.getName());

   public static class DBConn
   {
      private String uri;
      private String user_name;
      private String password;

      public String toString()
      {
         return uri() + " " + user_name;
      }

      public String uri() { return uri; }
      public String userName() { return user_name; }
      public String password() { return password; }
   }

   public DBConn     dbConn;


   // will not start without config-file
   // no reasonable code-defaults can be invented
   public static AuthZSettings getInstance(String propertiesFilename)
   {
      LOGGER.config("reading settings from : " + propertiesFilename);

      try
      {
         InputStream ins =
            AuthZSettings.class.getClassLoader().getResourceAsStream(propertiesFilename);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            DBConn    dbConn    = loadDBConn(properties);

            return new AuthZSettings(dbConn);
         }
         else
         {
            throw new IllegalStateException(propertiesFilename + " not found in classpath");
         }

      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + propertiesFilename + " file", ex);
      }
   }



   private AuthZSettings(DBConn dbConn)
   {
      this.dbConn    = dbConn;
   }


   private static DBConn loadDBConn(Properties properties)
   {
      LOGGER.fine("trace");

      DBConn dbconn = new AuthZSettings.DBConn();
      dbconn.uri       = properties.getProperty("db_uri", "").strip();
      dbconn.user_name = properties.getProperty("db_user_name", "").strip();
      dbconn.password  = properties.getProperty("db_password", "").strip();
      return dbconn;
   }
}

