
/* REC-SODA BAND parameter defines the interval(s) to be extracted
from the data using a floating point interval (xtype="interval") as defined
in DALI. */


class Band
{
   public enum System {WAVE_Barycentric, VELO_LSRK, NONE};

   System system;
   double wavelength[];


   public Band(String str)
   {
      this.wavelength = Parser.getDaliIntervalPositiveValues(str, "BAND");
   }

   public Band(double low, double up)
   {
      wavelength = new double[2];
      wavelength[0] = low;
      wavelength[1] = up;
   }

   public void setSystem(Band.System system) { this.system = system; }

   public String toString()
   {
      return "BAND " + wavelength[0] + " " + wavelength[1];
   }

}

