/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization;

import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.DeserializerBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.model.customization.CustomizationBuilder;

abstract class CustomizationBase
implements Customization,
ComponentBoundCustomization {
    private final AdapterBinding adapterBinding;
    private final SerializerBinding serializerBinding;
    private final DeserializerBinding deserializerBinding;
    private final boolean nillable;

    public CustomizationBase(CustomizationBuilder builder) {
        this.nillable = builder.isNillable();
        this.adapterBinding = builder.getAdapterInfo();
        this.serializerBinding = builder.getSerializerBinding();
        this.deserializerBinding = builder.getDeserializerBinding();
    }

    public CustomizationBase(CustomizationBase other) {
        this.nillable = other.isNillable();
        this.adapterBinding = other.getAdapterBinding();
        this.serializerBinding = other.getSerializerBinding();
        this.deserializerBinding = other.getDeserializerBinding();
    }

    @Override
    public boolean isNillable() {
        return this.nillable;
    }

    @Override
    public AdapterBinding getAdapterBinding() {
        return this.adapterBinding;
    }

    @Override
    public SerializerBinding getSerializerBinding() {
        return this.serializerBinding;
    }

    @Override
    public DeserializerBinding getDeserializerBinding() {
        return this.deserializerBinding;
    }
}

