/*
 * Decompiled with CFR 0.152.
 */
package uws.job.user;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import uws.job.JobList;
import uws.job.UWSJob;
import uws.job.user.JobOwner;

public final class DefaultJobOwner
implements JobOwner {
    private final String id;
    private String pseudo;
    private HashMap<String, Object> otherData = null;

    public DefaultJobOwner(String name) {
        this(name, name);
    }

    public DefaultJobOwner(String id, String pseudo) {
        this.id = id;
        this.pseudo = pseudo;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public final String getPseudo() {
        return this.pseudo;
    }

    public final void setPseudo(String pseudo) {
        this.pseudo = pseudo;
    }

    @Override
    public boolean hasReadPermission(JobList jl) {
        return true;
    }

    @Override
    public boolean hasWritePermission(JobList jl) {
        return true;
    }

    @Override
    public boolean hasReadPermission(UWSJob job) {
        return job == null || job.getOwner() == null || job.getOwner().equals(this);
    }

    @Override
    public boolean hasWritePermission(UWSJob job) {
        return job == null || job.getOwner() == null || job.getOwner().equals(this);
    }

    @Override
    public boolean hasExecutePermission(UWSJob job) {
        return job == null || job.getOwner() == null || job.getOwner().equals(this);
    }

    public String putUserData(String name, String value) {
        if (this.otherData == null) {
            this.otherData = new HashMap();
        }
        return (String)this.otherData.put(name, value);
    }

    public String getUserData(String name) {
        return this.otherData == null ? null : (String)this.otherData.get(name);
    }

    public String removeUserData(String name) {
        return this.otherData == null ? null : (String)this.otherData.remove(name);
    }

    public Set<String> getAllUserData() {
        return this.otherData == null ? null : this.otherData.keySet();
    }

    @Override
    public Map<String, Object> getDataToSave() {
        return this.otherData;
    }

    @Override
    public void restoreData(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        if (this.otherData == null) {
            this.otherData = new HashMap(data.size());
        }
        this.otherData.putAll(data);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JobOwner)) {
            return false;
        }
        String objId = ((JobOwner)obj).getID();
        return this.id == null && objId == null || this.id != null && objId != null && this.id.equals(objId);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

