/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Pol {
    private static final String ARG_POL = "POL";
    static final Set<String> POL_STATES = new HashSet<String>(Arrays.asList("I", "Q", "U", "V", "RR", "LL", "RL", "LR", "XX", "YY", "XY", "YX"));
    public String[] states;

    public static Pol parsePol(Map<String, String[]> params) {
        String[] valArr = params.get(ARG_POL);
        if (valArr == null) {
            return null;
        }
        if (valArr.length < 1) {
            return null;
        }
        return new Pol(valArr);
    }

    public static Pol parsePolFromJson(String jsonString) {
        ArrayList<String> valList = new ArrayList<String>();
        JSONParser parser = new JSONParser();
        try {
            JSONObject jObj = (JSONObject)parser.parse(jsonString);
            JSONArray jIval = (JSONArray)jObj.get((Object)"pol");
            if (jIval == null) {
                return null;
            }
            for (String state : jIval) {
                valList.add(state);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Pol(valList.toArray(new String[0]));
    }

    Pol(String[] values) {
        for (String pol : values) {
            if (POL_STATES.contains(pol)) continue;
            throw new IllegalArgumentException("POL value is " + pol + " but must be one of " + String.join((CharSequence)" ", POL_STATES));
        }
        this.states = values;
    }

    public String toString() {
        return "POL " + String.join((CharSequence)" ", this.states);
    }

    public String toJsonString() {
        JSONArray jArr = new JSONArray();
        for (String val : this.states) {
            jArr.add((Object)val);
        }
        return jArr.toString();
    }
}

