
#include <fstream>
#include <string>

//#include "config.hpp"
#include "json.hpp"
#include "mcutout_nljson.hpp"
#include "mcutout_ostream.hpp"
#include "mcutout.hpp"
#include "multicutout.hpp"


using json = nlohmann::json;

using namespace std;

string multicutout(string json_request_filename, const string fits_path, const string fits_cut_path)
{
   const bool ASSERTS = true;

   // read mcutout json from file

   std::ifstream ifs(json_request_filename);
   const std::string json_str( (std::istreambuf_iterator<char>(ifs) ),
         (std::istreambuf_iterator<char>()    ) );

   // do cutouts

   json jcuts = json::parse(json_str, nullptr, ASSERTS);
   vector<struct cut_param_s> cut_params = jcuts.get<vector<struct cut_param_s>>();
   struct mcutout_res_s mres = mcutout(cut_params, fits_path, fits_cut_path);

   return mres.tgz_filename;
}

