/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferEncoder;
import nom.tam.util.BufferPointer;

public class BufferedDataOutputStream
extends BufferedOutputStream
implements ArrayDataOutput {
    private final BufferPointer bufferPointer;
    private final BufferEncoder bufferEncoder;

    public BufferedDataOutputStream(OutputStream o) {
        super(o, 32768);
        this.bufferPointer = new BufferPointer(this.buf);
        this.bufferEncoder = new BufferEncoder(this.bufferPointer){

            @Override
            protected void needBuffer(int need) throws IOException {
                BufferedDataOutputStream.this.checkBuf(need);
                ((BufferedDataOutputStream)BufferedDataOutputStream.this).bufferPointer.bufferLength = BufferedDataOutputStream.this.count;
                ((BufferedDataOutputStream)BufferedDataOutputStream.this).bufferPointer.bufferOffset = BufferedDataOutputStream.this.count;
                BufferedDataOutputStream.this.count += need;
            }

            @Override
            protected void write(byte[] buf, int offset, int length) throws IOException {
                BufferedDataOutputStream.this.write(buf, offset, length);
            }
        };
    }

    public BufferedDataOutputStream(OutputStream o, int bufLength) {
        super(o, bufLength);
        this.bufferPointer = new BufferPointer(this.buf);
        this.bufferEncoder = new /* invalid duplicate definition of identical inner class */;
    }

    protected void checkBuf(int need) throws IOException {
        if (this.count + need > this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void write(boolean[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(boolean[] b, int start, int length) throws IOException {
        this.bufferEncoder.write(b, start, length);
    }

    @Override
    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int start, int length) throws IOException {
        this.bufferEncoder.write(c, start, length);
    }

    @Override
    public void write(double[] d) throws IOException {
        this.write(d, 0, d.length);
    }

    @Override
    public void write(double[] d, int start, int length) throws IOException {
        this.bufferEncoder.write(d, start, length);
    }

    @Override
    public void write(float[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    @Override
    public void write(float[] f, int start, int length) throws IOException {
        this.bufferEncoder.write(f, start, length);
    }

    @Override
    public void write(int[] i) throws IOException {
        this.write(i, 0, i.length);
    }

    @Override
    public void write(int[] i, int start, int length) throws IOException {
        this.bufferEncoder.write(i, start, length);
    }

    @Override
    public void write(long[] l) throws IOException {
        this.write(l, 0, l.length);
    }

    @Override
    public void write(long[] l, int start, int length) throws IOException {
        this.bufferEncoder.write(l, start, length);
    }

    @Override
    public void write(short[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(short[] s, int start, int length) throws IOException {
        this.bufferEncoder.write(s, start, length);
    }

    @Override
    public void write(String[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(String[] s, int start, int len) throws IOException {
        for (String element : s) {
            this.writeBytes(element);
        }
    }

    @Override
    public void writeArray(Object o) throws IOException {
        this.bufferEncoder.writeArray(o);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.bufferEncoder.writeBoolean(b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.bufferEncoder.writeByte(b);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(AsciiFuncs.getBytes(s), 0, s.length());
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.bufferEncoder.writeChar(c);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.bufferEncoder.writeChars(s);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.bufferEncoder.writeDouble(d);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.bufferEncoder.writeFloat(f);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.bufferEncoder.writeInt(i);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.bufferEncoder.writeLong(l);
    }

    @Deprecated
    public void writePrimitiveArray(Object o) throws IOException {
        this.writeArray(o);
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.bufferEncoder.writeShort(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        DataOutputStream d = new DataOutputStream(this){

            @Override
            public void close() throws IOException {
                this.flush();
            }
        };
        d.writeUTF(s);
        d.close();
    }
}

