
#ifndef SQLSCHEMA_HPP
#define SQLSCHEMA_HPP

#include <string>
#include <vector>

#include "colmap.hpp"

//---------------------------------------------------------
// multivalued command(s) return vector of string:
// * if database is implemented in more tables, returned
//   vector contains commands for each table and all commands
//   should be executed as transaction
// * if database is in one table, vector will have one
//   string only
//---------------------------------------------------------


class SqlSchema
{
   public:

      SqlSchema();
      void initCols(void);
      void appendRow(void);

      // groups of columns

      enum /* class */ obscoreColId {dataproduct_type, calib_level,
         obs_collection, obs_title, obs_id, obs_publisher_id,
         bib_reference, data_rights,
         access_url, access_format, access_estsize, target_name,
         s_ra, s_dec, s_fov, s_region, s_region_galactic, s_xel1, s_xel2, s_resolution,
         t_min, t_max, t_exptime, t_resolution, t_xel,
         em_min, em_max, vel_min, vel_max, em_res_power, em_xel,
         o_ucd,
         pol_states, pol_xel,
         facility_name, instrument_name,
         polygon_region_galactic, polygon_region, coordinates,
         proposal_id,
         policy, groups};

      colmap<obscoreColId, std::string> obscoreRow;

      // organize columns into tables

      enum Tables { obscore };

      std::map<Tables, std::string> m_columns;
      std::map<Tables, std::string> m_values;

      // utils

      std::string eto_string(enum Tables tid)
						{return tableNames[tid].substr(0, tableNames[tid].find(' ')); };

      void reset(void);
      std::string skl(std::string str); // skip last character

      std::map<Tables, std::string> tableNames{
         {obscore, "obscore"},
      };

};

#endif

