#!/bin/bash

set -eux

{
date
env

# set optional to defaults if:
# :- var not exist or is empty string/null
# -  var not exist
ENABLE_ASYNC_UWS=${ENABLE_ASYNC_UWS:-}
ACCESS_CONTEXT_ROOT=${ACCESS_CONTEXT_ROOT-soda}

OIDC_RAP_URL=${OIDC_RAP_URL:-}
OIDC_GMS_URL=${OIDC_GMS_URL:-}
OIDC_CLIENT=${OIDC_CLIENT:-}
OIDC_SECRET=${OIDC_SECRET:-}

AUTHZ_DB_URL=${AUTHZ_DB_URL:-}
AUTHZ_DB_USERNAME=${AUTHZ_DB_USERNAME:-}
AUTHZ_DB_PASSWORD=${AUTHZ_DB_PASSWORD:-}

KEYSTORE_ALIAS=${KEYSTORE_ALIAS:-}


# configure server


mkdir -p $CATALINA_BASE/conf/Catalina/localhost
cp $WEBAPP_DIR/META-INF/context.xml $CATALINA_BASE/conf/Catalina/localhost/$ACCESS_CONTEXT_ROOT.xml


if [ -f /etc/pki/tls/keystore.jks ] && [ -f /etc/pki/tls/keystore.pwd ];
then
   cp $CATALINA_BASE/conf/server-connector.xml-8443 $CATALINA_BASE/conf/server-connector.xml
fi

if [ -n $KEYSTORE_ALIAS ];
then
      echo "KEYSTORE_ALIAS: "$KEYSTORE_ALIAS
      sed -i "s/tomcat/$KEYSTORE_ALIAS/" $CATALINA_BASE/conf/server-connector.xml
fi


# configure webapp


if [ -z "$OIDC_RAP_URL" ] || [ -z "$OIDC_GMS_URL" ] || [ -z "$OIDC_CLIENT" ] || [ -z "$OIDC_SECRET" ] \
   [ -z "$AUTHZ_DB_URL" ] || [ -z "$AUTHZ_DB_USERNAME" ] || [ -z "$AUTHZ_DB_PASSWORD" ];
then
   echo "Some of OIDC_ or AUTHZ_ is not set. All must be set to activate security."
   touch $WEBAPP_DIR/WEB-INF/security.node.xml
else
   echo "Config IA2 OIDC ..."
   {
      echo "rap_uri=$OIDC_RAP_URL"
      echo "gms_uri=$OIDC_GMS_URL"
      echo "client_id=$OIDC_CLIENT"
      echo "client_secret=$OIDC_SECRET"
      echo "groups_autoload=true"
      echo "store_state_on_login_endpoint=true"
      echo "scope=openid email profile read:rap"
      echo "allow_anonymous_access=true"
   } > $WEBAPP_DIR/WEB-INF/classes/auth.properties

   echo "Config VLKB authorization ..."
   {
      echo "db_uri=$AUTHZ_DB_URL"
      echo "db_user_name=$AUTHZ_DB_USERNAME"
      echo "db_password=$AUTHZ_DB_PASSWORD"
   } > $WEBAPP_DIR/WEB-INF/classes/authpolicy.properties
 
   cp $WEBAPP_DIR/WEB-INF/security.node.xml.default $WEBAPP_DIR/WEB-INF/security.node.xml
fi


if [ -z "$ENABLE_ASYNC_UWS" ];
then
   echo "/async/uws endpoint not active."
	touch $WEBAPP_DIR/WEB-INF/async-uws.node.xml
else
   echo "/async/uws endpoint enabled."
   cp $WEBAPP_DIR/WEB-INF/async-uws.node.xml.default $WEBAPP_DIR/WEB-INF/async-uws.node.xml
fi


# create web-app endpoints
cat $WEBAPP_DIR/WEB-INF/web.xml.prolog \
    $WEBAPP_DIR/WEB-INF/security.node.xml \
    $WEBAPP_DIR/WEB-INF/soda.node.xml \
    $WEBAPP_DIR/WEB-INF/async-uws.node.xml \
 	 $WEBAPP_DIR/WEB-INF/web.xml.epilog > $WEBAPP_DIR/WEB-INF/web.xml



# config debug
DBG_LEVEL=${DEBUG_LEVEL:-CONFIG}
sed -i "s/.*ServletCutout\.level.*=.*/ServletCutout.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*ResolverFromId\.level.*=.*/ResolverFromId.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*SodaImpl\.level.*=.*/SodaImpl.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*VlkbCli\.level.*=.*/VlkbCli.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthPolicy\.level.*=.*/AuthPolicy.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthPolicyDb\.level.*=.*/AuthPolicyDb.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthZFilter\.level.*=.*/AuthZFilter.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthZ\.level.*=.*/AuthZ.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties


date
} 1> /tmp/start-soda.log 2>&1

exec $CATALINA_HOME/bin/catalina.sh run

