
#ifndef SQLSCHEMA_HPP
#define SQLSCHEMA_HPP

#include <string>
#include <vector>

#include "colmap.hpp"

//---------------------------------------------------------
// multivalued command(s) return vector of string:
// * if database is implemented in more tables, returned
//   vector contains commands for each table and all commands
//   should be executed as transaction
// * if database is in one table, vector will have one
//   string only
//---------------------------------------------------------


class SqlSchema
{
   public:

      SqlSchema();
      void initCols(void);
      void appendRow(void);


      // groups of columns

      enum class headersColId {header_id, filename, hdunum, pubdid, header, survey_id};
      enum boundsgalColId {bgheader_id, lfrom, lto, lunit, bfrom, bto, bunit, vfrom, vto, vunit};
      enum boundsicrsColId {biheader_id, rfrom, rto, runit, dfrom, dto, dunit};
      enum verticesgalColId {vgheader_id, p1lon, p1lat, p2lon, p2lat, p3lon, p3lat, p4lon, p4lat};
      enum verticesicrsColId {viheader_id, p1ra, p1dec, p2ra, p2dec, p3ra, p3dec, p4ra, p4dec};
      enum obscoreColId {dataproduct_type, calib_level,
         obs_collection, obs_id, obs_publisher_id,
         access_url, access_format, access_estsize, target_name,
         s_ra, s_dec, s_fov, s_region, s_xel1, s_xel2, s_resolution,
         t_min, t_max, t_exptime, t_resolution, t_xel,
         em_min, em_max, em_res_power, em_xel,
         o_ucd,
         pol_states, pol_xel,
         facility_name, instrument_name,
         polygon_region_galactic, polygon_region, coordinates,
         proposal_id,
         policy, groups};

      colmap<headersColId,      std::string> headersRow;
      colmap<boundsgalColId,    std::string> boundsgalRow;
      colmap<boundsicrsColId,   std::string> boundsicrsRow;
      colmap<verticesgalColId,  std::string> verticesgalRow;
      colmap<verticesicrsColId, std::string> verticesicrsRow;
      colmap<obscoreColId,      std::string> obscoreRow;


      // organize columns into tables

      enum Tables {headers,
         boundsgal, boundsicrs, verticesgal, verticesicrs,
         obscore};

      std::map<Tables, std::string> m_columns;
      std::map<Tables, std::string> m_values;

      // utils

      std::string eto_string(enum headersColId cid) {return headersRow[cid].substr(0, headersRow[cid].find(' ')); };
      std::string eto_string(enum boundsgalColId cid) {return boundsgalRow[cid].substr(0, boundsgalRow[cid].find(' ')); };

      std::string eto_string(enum Tables tid) {return tableNames[tid].substr(0, tableNames[tid].find(' ')); };

      void reset(void);
      std::string skl(std::string str);
      // skip last character

      std::map<Tables, std::string> tableNames{
         {headers , "headers"},
         {boundsgal, "cubeboundsgalactic"},
         {boundsicrs, "cubeboundsicrs"},
         {verticesgal, "verticesgalactic"},
         {verticesicrs, "verticesicrs"},
         {obscore, "obscore"},
      };

};

#endif

