import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.OutputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import uws.UWSException;
import uws.job.ErrorType;
import uws.job.JobThread;
import uws.job.user.JobOwner;
import uws.job.user.DefaultJobOwner;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.job.jobInfo.XMLJobInfo;
import uws.job.jobInfo.SingleValueJobInfo;

import uws.service.request.UploadFile;
import uws.service.file.LocalUWSFileManager;
import uws.service.file.UWSFileManager;
import uws.service.UWSUrl;

import uws.service.log.UWSLog;
import uws.service.log.UWSLog.LogLevel;

// rbu
import java.util.*; 
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;



public class UWSMCutoutWork extends JobThread
{
   private Settings     settings  = UWSMCutout.settings;
   private Subsurvey[] subsurveys = UWSMCutout.subsurveys;

   protected Vlkb vlkb = (settings.amqpConn.isHostnameEmpty() ?
         new VlkbCli(settings, subsurveys)
         : new VlkbAmqp(settings, subsurveys));

   /* NOTE needed if cutouts dir served by vlkb-datasets */
   private String webappRootRequestUrl = null;

   public UWSMCutoutWork(UWSJob j) throws UWSException
   {
      super(j);
      UWSUrl url = j.getUrl();
      webappRootRequestUrl = url.getUrlHeader();
   }



   @Override
   protected void jobWork() throws UWSException, InterruptedException
   {
		UWSLog logger = job.getLogger();

      try
      {
         long startTime_msec = System.currentTimeMillis();
         boolean showDuration = true;

         UploadFile jsonFile = (UploadFile)job.getAdditionalParameterValue("mcutout");

         InputStreamReader isr = new InputStreamReader(jsonFile.open());
         BufferedReader input = new BufferedReader(isr);
         StringBuffer jsonStringBuffer = new StringBuffer();
         String line;
         while((line = input.readLine()) != null)
         {
            jsonStringBuffer.append(line);
         }
         String reqJsonString = jsonStringBuffer.toString();

         MCutResult mresult = vlkb.doMCutout(reqJsonString);

			logger.logThread(LogLevel.INFO, this, "Prepare Result",
					" job:requestUrl: " +  job.getUrl().getRequestURL(), null);

			// publish Report

			Result resultRes = new Result("Report", "none", null, false);
			resultRes.setMimeType("application/json");
			OutputStream respResOutputStream = getResultOutput(resultRes);

			String absResPathname = mresult.resJsonPathname;
			File downloadResFile = new File(absResPathname);
			FileInputStream fileResInput = new FileInputStream(downloadResFile);

			fileResInput.transferTo(respResOutputStream);
			publishResult(resultRes);

			downloadResFile.delete();

			// publish mcutout.tar.gz

			final String id = "mcutout.tar.gz";
			Result result = new Result(id, "none", null, false);
			result.setMimeType("application/gzip");
			OutputStream respOutputStream = getResultOutput(result);

			String absCutPathname = mresult.fileName;
			File downloadFile = new File(absCutPathname);
			FileInputStream fileInput = new FileInputStream(downloadFile);

			fileInput.transferTo(respOutputStream);
			publishResult(result);

			downloadFile.delete();

			// delete cut-files (were published/copied to uws-file store) 

			mresult.deleteResJson();
			mresult.deleteCutFiles();


			/* FIXME here was uws-check is-job-Interrupted */
		}
		catch(IOException ex)
		{
			logger.error("MCutout error", ex);
			throw new UWSException("Internal error: jsonFile.open() throws IOException:" + ex.getMessage());
		}
	}

}
