#!/bin/bash

set -eux

{
date
env

# set optional
ACCESS_CONTEXT_ROOT=${ACCESS_CONTEXT_ROOT:-soda}

OIDC_RAP_URL=${OIDC_RAP_URL:-}
OIDC_GMS_URL=${OIDC_GMS_URL:-}
OIDC_CLIENT=${OIDC_CLIENT:-}
OIDC_SECRET=${OIDC_SECRET:-}

AUTHZ_DB_URL=${AUTHZ_DB_URL:-}
AUTHZ_DB_SCHEMA=${AUTHZ_DB_SCHEMA:-}
AUTHZ_DB_USERNAME=${AUTHZ_DB_USERNAME:-}
AUTHZ_DB_PASSWORD=${AUTHZ_DB_PASSWORD:-}

# deprecated
OIDC_INTROSPECT=${OIDC_INTROSPECT:-}
SECURITY=${SECURITY:-}
KEYSTORE_ALIAS=${KEYSTORE_ALIAS:-}



# configure CONTEXT_ROOT

mkdir -p $CATALINA_BASE/conf/Catalina/localhost
cp $WEBAPP_DIR/META-INF/context.xml $CATALINA_BASE/conf/Catalina/localhost/$ACCESS_CONTEXT_ROOT.xml


# env SECURITY (deprecated)

case $SECURITY in
   iamtoken)
      echo "SECURITY is set: "$SECURITY
      cd $WEBAPP_DIR/WEB-INF/ && rm -f web.xml && cp web-cutout-$SECURITY.xml web.xml && cd -
      cp /etc/pki/tls/server-connector.xml $CATALINA_BASE/conf
      cp /etc/pki/tls/iamtoken.properties $WEBAPP_DIR/WEB-INF/classes/
      ;;
   *)
      echo "SECURITY not configured."
      ;;
esac


# configure TLS

if [ -f /etc/pki/tls/keystore.jks ] && [ -f /etc/pki/tls/keystore.pwd ];
then
   cp $CATALINA_BASE/conf/server-connector.xml-8443 $CATALINA_BASE/conf/server-connector.xml
fi

if [ -n $KEYSTORE_ALIAS ];
then
      echo "KEYSTORE_ALIAS: "$KEYSTORE_ALIAS
      sed -i "s/tomcat/$KEYSTORE_ALIAS/" $CATALINA_BASE/conf/server-connector.xml
fi

# configure SKA IAM

if [ -z "$OIDC_INTROSPECT" ] || [ -z "$OIDC_CLIENT" ] || [ -z "$OIDC_PASSWORD" ];
then
   echo "Some of OIDC_ for SKA IAM is not set."
   echo "url: "$OIDC_INTROSPECT
   echo "cli: "$OIDC_CLIENT
   echo "pwd: "$OIDC_PASSWORD
else
   echo "Config SKA IAM ..."
   {
      echo "introspect=$OIDC_INTROSPECT"
      echo "client_name=$OIDC_CLIENT"
      echo "client_password=$OIDC_PASSWORD"
   } > $WEBAPP_DIR/WEB-INF/classes/iamtoken.properties
   cp $WEBAPP_DIR/WEB-INF/web-cutout-iamtoken.xml $WEBAPP_DIR/WEB-INF/web.xml
fi

# configure IA2 security

if [ -z "$OIDC_RAP_URL" ] || [ -z "$OIDC_GMS_URL" ] || [ -z "$OIDC_CLIENT" ] || [ -z "$OIDC_SECRET" ];
then
   echo "Some of OIDC_ for IA2 is not set."
   echo "rap: "$OIDC_RAP_URL
   echo "gms: "$OIDC_GMS_URL
   echo "cli: "$OIDC_CLIENT
   echo "pwd: "$OIDC_SECRET
else
   echo "Config IA2 OIDC ..."
   {
      echo "rap_uri=$OIDC_RAP_URL"
      echo "gms_uri=$OIDC_GMS_URL"
      echo "client_id=$OIDC_CLIENT"
      echo "client_secret=$OIDC_SECRET"
      echo "groups_autoload=true"
      echo "store_state_on_login_endpoint=true"
      echo "scope=openid email profile read:rap"
      echo "allow_anonymous_access=true"
   } > $WEBAPP_DIR/WEB-INF/classes/ia2token.properties
   cp $WEBAPP_DIR/WEB-INF/web-cutout-ia2token.xml $WEBAPP_DIR/WEB-INF/web.xml
fi

# VLKB authorization

if [ -z "$AUTHZ_DB_URL" ] || [ -z "$AUTHZ_DB_SCHEMA" ] || [ -z "$AUTHZ_DB_USERNAME" ] || [ -z "$AUTHZ_DB_PASSWORD" ];
then
   echo "Some of AUTHZ_DB_ is not set."
else
   echo "Config VLKB authorization ..."
   {
      echo "db_uri=$AUTHZ_DB_URL"
      echo "db_schema=$AUTHZ_DB_SCHEMA"
      echo "db_user_name=$AUTHZ_DB_USERNAME"
      echo "db_password=$AUTHZ_DB_PASSWORD"
   } > $WEBAPP_DIR/WEB-INF/classes/authpolicy.properties
   #cp $WEBAPP_DIR/WEB-INF/web-cutout-ia2token.xml $WEBAPP_DIR/WEB-INF/web.xml
fi




# config debug
DBG_LEVEL=${DEBUG_LEVEL:-CONFIG}
sed -i "s/.*ServletCutout\.level.*=.*/ServletCutout.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*ResolverFromId\.level.*=.*/ResolverFromId.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*SodaImpl\.level.*=.*/SodaImpl.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*VlkbCli\.level.*=.*/VlkbCli.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthPolicy\.level.*=.*/AuthPolicy.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthPolicyDb\.level.*=.*/AuthPolicyDb.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthZFilter\.level.*=.*/AuthZFilter.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties
sed -i "s/.*AuthZ\.level.*=.*/AuthZ.level = $DBG_LEVEL/g" $CATALINA_BASE/conf/soda.logging.properties


date
} 1> /tmp/start-soda.log 2>&1

$CATALINA_HOME/bin/catalina.sh run

