/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import it.inaf.ia2.client.BaseClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCall<T extends BaseClient> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(BaseCall.class);
    protected final T client;

    public BaseCall(T client) {
        this.client = client;
    }

    public static <T> T parseJson(String value, Class<T> type) {
        try {
            return (T)MAPPER.readValue(value, type);
        }
        catch (IOException ex) {
            LOG.error("Invalid JSON for class {}:\n{}", (Object)type.getCanonicalName(), (Object)value);
            throw new UncheckedIOException(ex);
        }
    }

    public static <T> T parseJson(InputStream in, Class<T> type) {
        try {
            return (T)MAPPER.readValue(in, type);
        }
        catch (IOException ex) {
            LOG.error("Invalid JSON for class {}", (Object)type.getCanonicalName());
            throw new UncheckedIOException(ex);
        }
    }

    public static <T> List<T> parseJsonList(InputStream in, Class<T> type) {
        try {
            CollectionType listType = MAPPER.getTypeFactory().constructCollectionType(List.class, type);
            return (List)MAPPER.readValue(in, (JavaType)listType);
        }
        catch (IOException ex) {
            LOG.error("Invalid JSON for class {}", (Object)type.getCanonicalName());
            throw new UncheckedIOException(ex);
        }
    }

    public static String toJson(Object data) {
        try {
            return MAPPER.writeValueAsString(data);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

