/*
 * Decompiled with CFR 0.152.
 */
package uws.service.request;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.service.request.RequestParser;

public class FormEncodedParser
implements RequestParser {
    public static final String EXPECTED_CONTENT_TYPE = "application/x-www-form-urlencoded";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<String, Object> parse(HttpServletRequest request) throws UWSException {
        if (request == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getMethod() == null || !request.getMethod().equalsIgnoreCase("put")) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                int i;
                String paramName = (String)names.nextElement();
                String[] values = request.getParameterValues(paramName);
                for (i = values.length - 1; i >= 0 && values[i] == null; --i) {
                }
                if (i < 0) continue;
                this.consumeParameter(paramName, values[i], params);
            }
        } else {
            InputStream input = null;
            Scanner scanner = null;
            try {
                String charEncoding = request.getCharacterEncoding();
                try {
                    if (charEncoding == null || charEncoding.trim().length() == 0 || Charset.isSupported(charEncoding)) {
                        charEncoding = "UTF-8";
                    }
                }
                catch (Exception ex) {
                    charEncoding = "UTF-8";
                }
                input = new BufferedInputStream((InputStream)request.getInputStream());
                scanner = new Scanner(input);
                scanner.useDelimiter("&");
                while (scanner.hasNext()) {
                    String pair = scanner.next();
                    int indSep = pair.indexOf(61);
                    try {
                        if (indSep >= 0) {
                            this.consumeParameter(URLDecoder.decode(pair.substring(0, indSep), charEncoding), URLDecoder.decode(pair.substring(indSep + 1), charEncoding), params);
                            continue;
                        }
                        this.consumeParameter(URLDecoder.decode(pair, charEncoding), "", params);
                    }
                    catch (UnsupportedEncodingException uee) {
                        if (indSep >= 0) {
                            this.consumeParameter(pair.substring(0, indSep), pair.substring(indSep + 1), params);
                            continue;
                        }
                        this.consumeParameter(pair, "", params);
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return params;
    }

    protected void consumeParameter(String name, Object value, Map<String, Object> allParams) {
        allParams.put(name, value);
    }

    public static final boolean isFormEncodedRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(EXPECTED_CONTENT_TYPE);
    }
}

