/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TileDecompressor;
import nom.tam.image.compression.tile.TiledImageCompressionOperation;
import nom.tam.image.tile.operation.ITileOperationInitialisation;
import nom.tam.image.tile.operation.TileArea;

final class TileDecompressorInitialisation
implements ITileOperationInitialisation<TileCompressionOperation> {
    private final Object[] uncompressed;
    private final Object[] compressed;
    private final Object[] gzipCompressed;
    private final Header header;
    private final TiledImageCompressionOperation imageTilesOperation;
    private int compressedOffset = 0;

    protected TileDecompressorInitialisation(TiledImageCompressionOperation imageTilesOperation, Object[] uncompressed, Object[] compressed, Object[] gzipCompressed, Header header) {
        this.imageTilesOperation = imageTilesOperation;
        this.uncompressed = uncompressed;
        this.compressed = compressed;
        this.gzipCompressed = gzipCompressed;
        this.header = header;
    }

    @Override
    public TileCompressionOperation createTileOperation(int tileIndex, TileArea area) {
        return new TileDecompressor(this.imageTilesOperation, tileIndex, area);
    }

    @Override
    public void init(TileCompressionOperation tileOperation) {
        tileOperation.setCompressedOffset(this.compressedOffset).setCompressed(this.compressed != null ? this.compressed[tileOperation.getTileIndex()] : null, TileCompressionType.COMPRESSED).setCompressed(this.uncompressed != null ? this.uncompressed[tileOperation.getTileIndex()] : null, TileCompressionType.UNCOMPRESSED).setCompressed(this.gzipCompressed != null ? this.gzipCompressed[tileOperation.getTileIndex()] : null, TileCompressionType.GZIP_COMPRESSED);
        this.compressedOffset += tileOperation.getPixelSize();
    }

    @Override
    public void tileCount(int tileCount) {
        try {
            this.imageTilesOperation.compressOptions().getCompressionParameters().initializeColumns(this.header, this.imageTilesOperation.getBinaryTable(), tileCount);
        }
        catch (FitsException e) {
            throw new IllegalStateException("Columns of table inconsistent", e);
        }
    }
}

