/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import vo.parameter.Interval;
import vo.parameter.Parser;

public class Band
extends Interval {
    protected static final Logger LOGGER = Logger.getLogger("Band");
    private static final String ARG_BAND = "BAND";
    private static final String ARG_BANDSYS = "BANDSYS";
    public System system;

    private static Band vlkbReq_getVelocity(Map<String, String[]> params, String strSystem) {
        boolean vel_valid;
        Band band = null;
        String cvlow = Parser.getSingleValue(params, "vl");
        String cvup = Parser.getSingleValue(params, "vu");
        boolean bl = vel_valid = cvlow != null && cvup != null;
        if (vel_valid) {
            double vel_low = Double.parseDouble(cvlow);
            double vel_up = Double.parseDouble(cvup);
            band = new Band(vel_low, vel_up, strSystem);
        }
        return band;
    }

    public static Band parseBandFromJson(String jsonString, String defaultSystem) {
        JSONParser parser = new JSONParser();
        String strValue = null;
        String strSystem = null;
        try {
            double max;
            double min;
            JSONObject jObj = (JSONObject)parser.parse(jsonString);
            strSystem = (String)jObj.get((Object)"bandsys");
            JSONArray jIval = (JSONArray)jObj.get((Object)"band");
            if (jIval == null) {
                LOGGER.info("band not in json; implement here parse Legacy vl,vu");
                return null;
            }
            Iterator it = jIval.iterator();
            if (jIval.size() == 1) {
                max = min = ((Double)it.next()).doubleValue();
            } else if (jIval.size() == 2) {
                min = (Double)it.next();
                max = (Double)it.next();
            } else {
                throw new IllegalArgumentException("Band interval must have 1 or 2 values, but found: " + jIval.size() + " values");
            }
            strValue = String.valueOf(min) + " " + String.valueOf(max);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Band(strValue, strSystem);
    }

    public static Band parseBand(Map<String, String[]> params, String defaultSystem) {
        String strValue;
        String strSystem = Parser.getSingleValue(params, ARG_BANDSYS);
        if (strSystem == null) {
            strSystem = Parser.getSingleValue(params, "specsystem", defaultSystem);
        }
        if ((strValue = Parser.getSingleValue(params, ARG_BAND)) == null) {
            return Band.vlkbReq_getVelocity(params, strSystem);
        }
        return new Band(strValue, strSystem);
    }

    public Band(String strValue, String strSystem) {
        super(strValue);
        this.system = System.valueOf(strSystem);
    }

    public Band(double min, double max, String strSystem) {
        super(min, max);
        this.system = System.valueOf(strSystem);
    }

    public void setSystem(String strSystem) {
        this.system = System.valueOf(strSystem);
    }

    public String toString() {
        return super.toString(ARG_BAND) + "&BANDSYS=" + this.system.toString();
    }

    public String toJsonString() {
        JSONObject j = new JSONObject();
        j.put((Object)"bandsys", (Object)this.system.toString());
        JSONArray arr = new JSONArray();
        arr.add((Object)this.getMin());
        arr.add((Object)this.getMax());
        j.put((Object)"band", (Object)arr);
        return j.toString();
    }

    public static enum System {
        WAVE_Barycentric,
        VELO_LSRK,
        GRID,
        NONE;

    }
}

