/*
 * Decompiled with CFR 0.152.
 */
package uws;

import uws.job.ErrorType;

public class UWSException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int OK = 200;
    public static final int ACCEPTED_BUT_NOT_COMPLETE = 202;
    public static final int NO_CONTENT = 204;
    public static final int SEE_OTHER = 303;
    public static final int BAD_REQUEST = 400;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int NOT_ALLOWED = 405;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int USER_ACCESS_DENIED = 530;
    public static final int PERMISSION_DENIED = 550;
    protected int httpErrorCode = 404;
    protected ErrorType errorType = ErrorType.FATAL;

    public UWSException(String msg) {
        this(msg, (ErrorType)null);
    }

    public UWSException(String msg, ErrorType type) {
        super(msg);
        this.errorType = type == null ? ErrorType.FATAL : type;
    }

    public UWSException(Throwable t) {
        this(t, null);
    }

    public UWSException(Throwable t, ErrorType type) {
        super(t);
        this.errorType = type == null ? ErrorType.FATAL : type;
    }

    public UWSException(int httpError, String msg) {
        this(httpError, msg, null);
    }

    public UWSException(int httpError, String msg, ErrorType type) {
        this(msg, type);
        this.httpErrorCode = httpError < 0 ? 404 : httpError;
    }

    public UWSException(int httpError, Throwable t) {
        this(httpError, t, t != null ? t.getMessage() : null, null);
    }

    public UWSException(int httpError, Throwable t, ErrorType type) {
        this(httpError, t, t != null ? t.getMessage() : null, type);
    }

    public UWSException(int httpError, Throwable t, String msg) {
        this(httpError, t, msg, null);
    }

    public UWSException(int httpError, Throwable t, String msg, ErrorType type) {
        super(msg, t);
        this.httpErrorCode = httpError < 0 ? 404 : httpError;
        this.errorType = type == null ? ErrorType.FATAL : type;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public ErrorType getUWSErrorType() {
        return this.errorType;
    }
}

