/*
 * Decompiled with CFR 0.152.
 */
package uws.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.job.ErrorSummary;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.job.parameters.DestructionTimeController;
import uws.job.parameters.ExecutionDurationController;
import uws.job.parameters.InputParamController;
import uws.job.parameters.UWSParameters;
import uws.job.user.JobOwner;
import uws.service.UWSFactory;
import uws.service.file.UWSFileManager;
import uws.service.request.RequestParser;
import uws.service.request.UWSRequestParser;

public abstract class AbstractUWSFactory
implements UWSFactory {
    protected final HashMap<String, InputParamController> inputParamControllers = new HashMap(10);
    protected final ArrayList<String> expectedAdditionalParams = new ArrayList(10);

    public AbstractUWSFactory() {
    }

    public AbstractUWSFactory(String[] expectedAdditionalParams) {
        if (expectedAdditionalParams != null) {
            for (String p : expectedAdditionalParams) {
                if (p == null || p.trim().isEmpty()) continue;
                this.expectedAdditionalParams.add(p);
            }
        }
    }

    @Override
    public UWSJob createJob(HttpServletRequest request, JobOwner user) throws UWSException {
        String requestID = null;
        if (request != null && request.getAttribute("UWS_REQUEST_ID") != null && request.getAttribute("UWS_REQUEST_ID") instanceof String) {
            requestID = request.getAttribute("UWS_REQUEST_ID").toString();
        }
        UWSJob newJob = new UWSJob(user, this.createUWSParameters(request), requestID);
        Object jobDesc = request.getAttribute("UWS_JOB_DESCRIPTION");
        if (jobDesc != null && jobDesc instanceof JobInfo) {
            newJob.setJobInfo((JobInfo)jobDesc);
        }
        return newJob;
    }

    @Override
    public UWSJob createJob(String jobID, long creationTime, JobOwner owner, UWSParameters params, long quote, long startTime, long endTime, List<Result> results, ErrorSummary error) throws UWSException {
        return new UWSJob(jobID, creationTime, owner, params, quote, startTime, endTime, results, error);
    }

    @Override
    public UWSParameters createUWSParameters(Map<String, Object> params) throws UWSException {
        return new UWSParameters(params, this.expectedAdditionalParams, this.inputParamControllers);
    }

    @Override
    public UWSParameters createUWSParameters(HttpServletRequest req) throws UWSException {
        return new UWSParameters(req, this.expectedAdditionalParams, this.inputParamControllers);
    }

    @Override
    public RequestParser createRequestParser(UWSFileManager fileManager) throws UWSException {
        return new UWSRequestParser(fileManager);
    }

    public final void addExpectedAdditionalParameter(String paramName) {
        if (paramName != null && !paramName.trim().isEmpty()) {
            this.expectedAdditionalParams.add(paramName);
        }
    }

    public final int getNbExpectedAdditionalParameters() {
        return this.expectedAdditionalParams.size();
    }

    public final List<String> getExpectedAdditionalParameters() {
        return this.expectedAdditionalParams;
    }

    public final Iterator<String> expectedAdditionalParametersIterator() {
        return this.expectedAdditionalParams.iterator();
    }

    public final void removeExpectedAdditionalParam(String paramName) {
        if (paramName != null && !paramName.trim().isEmpty()) {
            this.expectedAdditionalParams.remove(paramName);
        }
    }

    public final Map<String, InputParamController> getInputParamControllers() {
        return this.inputParamControllers;
    }

    public final Iterator<Map.Entry<String, InputParamController>> getInputParamControllersIterator() {
        return this.inputParamControllers.entrySet().iterator();
    }

    public final InputParamController getInputParamController(String inputParamName) {
        return inputParamName == null ? null : this.inputParamControllers.get(inputParamName);
    }

    public final InputParamController setInputParamController(String paramName, InputParamController controller) {
        if (paramName == null || paramName.trim().isEmpty()) {
            return null;
        }
        if (controller == null) {
            return this.inputParamControllers.remove(paramName);
        }
        return this.inputParamControllers.put(paramName, controller);
    }

    public final InputParamController removeInputParamController(String paramName) {
        return paramName == null ? null : this.inputParamControllers.remove(paramName);
    }

    public final void configureExecution(long defaultDuration, long maxDuration, boolean allowModif) {
        InputParamController controller = this.inputParamControllers.get("executionDuration");
        if (controller != null && controller instanceof ExecutionDurationController) {
            ExecutionDurationController durationController = (ExecutionDurationController)controller;
            durationController.setMaxExecutionDuration(maxDuration);
            durationController.setDefaultExecutionDuration(defaultDuration);
            durationController.allowModification(allowModif);
        } else {
            this.inputParamControllers.put("executionDuration", new ExecutionDurationController(defaultDuration, maxDuration, allowModif));
        }
    }

    public final void configureDestruction(int defaultTime, DestructionTimeController.DateField defaultTimeUnit, int maxTime, DestructionTimeController.DateField maxTimeUnit, boolean allowModif) {
        DestructionTimeController destructionController;
        InputParamController controller = this.inputParamControllers.get("destruction");
        if (controller == null || !(controller instanceof DestructionTimeController)) {
            destructionController = new DestructionTimeController();
            this.inputParamControllers.put("destruction", destructionController);
        } else {
            destructionController = (DestructionTimeController)controller;
        }
        destructionController.setMaxDestructionInterval(maxTime, maxTimeUnit);
        destructionController.setDefaultDestructionInterval(defaultTime, defaultTimeUnit);
        destructionController.allowModification(allowModif);
    }
}

